/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.neural;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;
import synnalagma.neural.Layer;
import synnalagma.neural.NNError;
import synnalagma.neural.NTestRet;
import synnalagma.neural.NrPop;
import synnalagma.shooting.NeuralShoot;

public class NNet {
    Layer[] lyr;

    NNet() {
    }

    NNet(int n) {
        this.lyr = new Layer[n];
    }

    public NNet(int n, int n2, int n3, boolean bl, float f, float f2) {
        String string = "NodeLin";
        String string2 = "NodeSigm";
        int n4 = bl ? 4 : 3;
        this.lyr = new Layer[n4];
        this.lyr[0] = new Layer(0, n, string);
        if (bl) {
            this.lyr[1] = new Layer(1, n2, string2);
            this.lyr[2] = new Layer(2, n2, string2);
            this.lyr[2].mbuff = this.lyr[1];
            this.lyr[3] = new Layer(3, n3, string2);
        } else {
            this.lyr[1] = new Layer(1, n2, string2);
            this.lyr[2] = new Layer(2, n3, string2);
        }
        if (bl) {
            this.lyr[2].linkFromAll(this.lyr[0], f, f2);
            this.lyr[2].linkFromAll(this.lyr[1], f, f2);
            this.lyr[3].linkFromAll(this.lyr[2], f, f2);
        } else {
            this.lyr[1].linkFromAll(this.lyr[0], f, f2);
            this.lyr[2].linkFromAll(this.lyr[1], f, f2);
        }
    }

    public NNet(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, NrPop.ra, NrPop.rb);
    }

    public NNet(int n, int n2, int n3) {
        this(n, n2, n3, false, NrPop.ra, NrPop.rb);
    }

    public NNet(String[] stringArray) {
        this(stringArray, 0);
    }

    public NNet(String string) {
        this(NrPop.fileToStrArray(string), 0);
    }

    NNet(String[] stringArray, int n) {
        String string;
        int n2;
        int n3;
        String string2;
        String string3;
        String string4;
        StringTokenizer stringTokenizer;
        String string5 = this.getClass().getName();
        String string6 = string5.substring(0, string5.lastIndexOf(46) + 1);
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        String string7 = "";
        boolean bl = false;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        float f = NrPop.ra;
        float f2 = NrPop.rb;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n18 = n;
        while (n18 < stringArray.length) {
            stringTokenizer = new StringTokenizer(stringArray[n18]);
            if (stringTokenizer.countTokens() >= 1) {
                string4 = stringTokenizer.nextToken();
                if (string4.startsWith("layer=")) {
                    string3 = string4.substring(string4.indexOf(61));
                    string2 = NrPop.values(string3, 1);
                    try {
                        n5 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        NNError.err("Layer Number missed at rec " + n18);
                    }
                    if (n5 > n4) {
                        n4 = n5;
                    }
                }
                if (string4.startsWith("net=")) break;
            }
            ++n18;
        }
        this.lyr = new Layer[n4 + 1];
        n18 = n;
        while (n18 < stringArray.length) {
            stringTokenizer = new StringTokenizer(stringArray[n18]);
            if (stringTokenizer.countTokens() >= 1) {
                string4 = stringTokenizer.nextToken();
                if (string4.startsWith("layer=")) {
                    n3 = stringTokenizer.countTokens();
                    string3 = string4.substring(string4.indexOf(61));
                    string2 = NrPop.values(string3, 1);
                    try {
                        n5 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        NNError.err("Layer Number missed at rec " + n18);
                    }
                    n2 = 1;
                    while (n2 <= n3) {
                        string4 = stringTokenizer.nextToken();
                        if (string4.startsWith("tnode=")) {
                            string3 = string4.substring(string4.indexOf(61));
                            string2 = NrPop.values(string3, 1);
                            string = NrPop.values(string3, 2);
                            try {
                                n6 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                NNError.err("O node total at rec " + n18);
                            }
                            try {
                                n7 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                n7 = 0;
                            }
                        } else if (string4.startsWith("nname=")) {
                            string3 = string4.substring(string4.indexOf(61));
                            string7 = string2 = NrPop.values(string3, 1);
                        }
                        ++n2;
                    }
                    if (string7.length() == 0 && n5 == 0) {
                        string7 = string6 + "NodeLin";
                    }
                    if (string7.length() == 0 && n5 != 0) {
                        string7 = string6 + "NodeSigm";
                    }
                    this.lyr[n5] = n7 == 0 ? new Layer(n5, n6, string7) : new Layer(n5, n6, n7, string7);
                }
                if (string4.startsWith("net=")) break;
            }
            ++n18;
        }
        n18 = n;
        while (n18 < stringArray.length) {
            stringTokenizer = new StringTokenizer(stringArray[n18]);
            if (stringTokenizer.countTokens() >= 1) {
                string4 = stringTokenizer.nextToken();
                if (string4.startsWith("layer=")) {
                    n3 = stringTokenizer.countTokens();
                    string3 = string4.substring(string4.indexOf(61));
                    string2 = NrPop.values(string3, 1);
                    try {
                        n5 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        NNError.err("Layer Number missed at rec " + n18);
                    }
                    n2 = 1;
                    while (n2 <= n3) {
                        string4 = stringTokenizer.nextToken();
                        if (string4.startsWith("copytoml=")) {
                            string3 = string4.substring(string4.indexOf(61));
                            string2 = NrPop.values(string3, 1);
                            try {
                                n8 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                NNError.err("No layer memory number at rec " + n18);
                            }
                        }
                        ++n2;
                    }
                    if (n8 > 0 && n8 <= n4) {
                        this.lyr[n5].mbuff = this.lyr[n8];
                    }
                }
                if (string4.startsWith("net=")) break;
            }
            ++n18;
        }
        n18 = n;
        while (n18 < stringArray.length) {
            block74: {
                stringTokenizer = new StringTokenizer(stringArray[n18]);
                if (stringTokenizer.countTokens() >= 1) {
                    String string8;
                    string4 = stringTokenizer.nextToken();
                    if (string4.startsWith("linktype=")) {
                        n3 = stringTokenizer.countTokens();
                        string3 = string4.substring(string4.indexOf(61));
                        string2 = NrPop.values(string3, 1);
                        bl = string2.compareToIgnoreCase("one") == 0;
                        n2 = 1;
                        while (n2 <= n3) {
                            block73: {
                                string4 = stringTokenizer.nextToken();
                                if (string4.startsWith("fromlayer=")) {
                                    string3 = string4.substring(string4.indexOf(61));
                                    string2 = NrPop.values(string3, 1);
                                    string = NrPop.values(string3, 2);
                                    string8 = NrPop.values(string3, 3);
                                    try {
                                        n9 = Integer.parseInt(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        NNError.err("Layer Number missed at rec " + n18);
                                    }
                                    try {
                                        n11 = Integer.parseInt(string);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        n11 = 0;
                                    }
                                    try {
                                        n12 = Integer.parseInt(string8);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        n12 = this.lyr[n9].node.length - 1;
                                    }
                                } else if (string4.startsWith("tolayer=")) {
                                    string3 = string4.substring(string4.indexOf(61));
                                    string2 = NrPop.values(string3, 1);
                                    string = NrPop.values(string3, 2);
                                    string8 = NrPop.values(string3, 3);
                                    try {
                                        n10 = Integer.parseInt(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        NNError.err("Layer Number missed at rec " + n18);
                                    }
                                    try {
                                        n13 = Integer.parseInt(string);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        n13 = 0;
                                    }
                                    try {
                                        n14 = Integer.parseInt(string8);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        n14 = this.lyr[n10].node.length - 1;
                                    }
                                } else if (string4.startsWith("value=")) {
                                    string3 = string4.substring(string4.indexOf(61));
                                    string2 = NrPop.values(string3, 1);
                                    string = NrPop.values(string3, 2);
                                    try {
                                        f = Float.parseFloat(string2);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        f = NrPop.ra;
                                        f2 = NrPop.rb;
                                        break block73;
                                    }
                                    try {
                                        f2 = Float.parseFloat(string);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        f2 = f;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (n9 >= 0 && n9 <= n4 && n10 >= 0 && n10 <= n4) {
                            if (bl) {
                                this.lyr[n10].linkOneToOne(n13, n14 - n13 + 1, n11, this.lyr[n9], f, f2);
                            }
                            if (!bl) {
                                this.lyr[n10].linkFromAll(n13, n14 - n13 + 1, n11, n12 - n11 + 1, this.lyr[n9], f, f2);
                            }
                        }
                    }
                    if (string4.startsWith("biasval=")) {
                        n3 = stringTokenizer.countTokens();
                        string3 = string4.substring(string4.indexOf(61));
                        string2 = NrPop.values(string3, 1);
                        string = NrPop.values(string3, 2);
                        try {
                            f3 = Float.parseFloat(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            f3 = NrPop.ra;
                            f4 = NrPop.rb;
                            break block74;
                        }
                        try {
                            f4 = Float.parseFloat(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            f4 = f3;
                        }
                        n2 = 1;
                        while (n2 <= n3) {
                            string4 = stringTokenizer.nextToken();
                            if (string4.startsWith("oflayer=")) {
                                string3 = string4.substring(string4.indexOf(61));
                                string2 = NrPop.values(string3, 1);
                                string = NrPop.values(string3, 2);
                                string8 = NrPop.values(string3, 3);
                                try {
                                    n15 = Integer.parseInt(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    NNError.err("Layer Number missed at rec " + n18);
                                }
                                try {
                                    n16 = Integer.parseInt(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n16 = 0;
                                }
                                try {
                                    n17 = Integer.parseInt(string8);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    n17 = this.lyr[n15].node.length - 1;
                                }
                            }
                            ++n2;
                        }
                        if (n15 >= 0 && n15 <= n4) {
                            this.lyr[n15].setBias(n16, n17 - n16 + 1, f3, f4);
                        }
                    }
                    if (string4.startsWith("net=")) break;
                }
            }
            ++n18;
        }
    }

    public int getLdim() {
        return this.lyr.length;
    }

    public int getLnodes(int n) {
        return this.lyr[n].node.length;
    }

    public float getLNBias(int n, int n2) {
        return this.lyr[n].getBias(n2);
    }

    public void setLNBias(int n, int n2, float f) {
        this.lyr[n].setBias(n2, f);
    }

    public void setLInp(int n, int n2, int n3, float[] fArray) {
        this.lyr[n].inp(n2, n3, fArray);
    }

    public void setLInp(int n, int n2, float f) {
        this.lyr[n].inp(n2, f);
    }

    public float setLOexp(int n, int n2, int n3, float[] fArray) {
        return this.lyr[n].err(n2, n3, fArray);
    }

    public float setLOexp(int n, int n2, float f) {
        return this.lyr[n].err(n2, f);
    }

    public void getLOut(int n, int n2, int n3, float[] fArray) {
        this.lyr[n].out(n2, n3, fArray);
    }

    public float getLOut(int n, int n2, float f) {
        return this.lyr[n].out(n2);
    }

    public void frwNNet() {
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].frwLayer();
            ++n;
        }
    }

    public void frwNNet(float[] fArray) {
        int n = fArray.length < this.lyr[0].node.length ? fArray.length : this.lyr[0].node.length;
        this.lyr[0].inp(0, n, fArray);
        int n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].frwLayer();
            ++n2;
        }
    }

    public void frwNNet(float[] fArray, float[] fArray2) {
        int n = fArray.length < this.lyr[0].node.length ? fArray.length : this.lyr[0].node.length;
        int n2 = fArray2.length < this.lyr[this.lyr.length - 1].node.length ? fArray.length : this.lyr[this.lyr.length - 1].node.length;
        this.lyr[0].inp(0, n, fArray);
        int n3 = 0;
        while (n3 < this.lyr.length) {
            this.lyr[n3].frwLayer();
            ++n3;
        }
        this.lyr[this.lyr.length - 1].out(0, n2, fArray2);
    }

    public float testNNet(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        int n = this.lyr[this.lyr.length - 1].node.length;
        float[] fArray3 = new float[n];
        int n2 = fArray2.length < n ? fArray2.length : n;
        this.frwNNet(fArray, fArray3);
        int n3 = 0;
        while (n3 < n2) {
            float f2 = fArray2[n3] - fArray3[n3];
            f += f2 * f2;
            ++n3;
        }
        return f /= (float)n2;
    }

    NTestRet testStructNNet(float[] fArray, float[] fArray2) {
        NTestRet nTestRet = new NTestRet();
        int n = this.lyr[this.lyr.length - 1].node.length;
        float[] fArray3 = new float[n];
        int n2 = fArray2.length < n ? fArray2.length : n;
        this.frwNNet(fArray, fArray3);
        int n3 = 0;
        while (n3 < n2) {
            float f = fArray2[n3] - fArray3[n3];
            float f2 = Math.abs(f);
            nTestRet.errm += f;
            nTestRet.errqm += f * f;
            if (f2 < nTestRet.minerr) {
                nTestRet.minerr = f2;
            }
            if (f2 > nTestRet.maxerr) {
                nTestRet.maxerr = f2;
            }
            if ((double)f2 > 0.5) {
                nTestRet.digiterr += 1.0f;
            }
            ++n3;
        }
        nTestRet.errm /= (float)n2;
        nTestRet.errqm /= (float)n2;
        nTestRet.dist = (float)(Math.sqrt(nTestRet.errqm) / Math.sqrt(n2));
        return nTestRet;
    }

    public float testNNet(String[] stringArray) {
        float f = 0.0f;
        if (stringArray.length < 1) {
            return f;
        }
        if (this.lyr.length < 1) {
            return f;
        }
        int n = this.lyr.length - 1;
        int n2 = this.lyr[0].node.length;
        int n3 = this.lyr[n].node.length;
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n3];
        int n4 = 0;
        while (n4 < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n4]);
            try {
                String string;
                int n5 = 0;
                while (n5 < n2) {
                    string = stringTokenizer.nextToken();
                    fArray[n5] = Float.parseFloat(string);
                    ++n5;
                }
                n5 = 0;
                while (n5 < n3) {
                    string = stringTokenizer.nextToken();
                    fArray2[n5] = Float.parseFloat(string);
                    ++n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                NNError.err("Missmatch value in train record " + n4);
            }
            f += this.testNNet(fArray, fArray2);
            ++n4;
        }
        return f / (float)stringArray.length;
    }

    public void NNetFilter(String string, String string2) {
        this.outNNet(string, string2, false, false, false, false);
    }

    public void verifyNNet(String string) {
        this.outNNet(string, "", false, false, true, false);
    }

    public void trainNNet(String string, String string2) {
        this.outNNet(string, string2, true, false, false, true);
    }

    public void outNNet(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block24: {
            float f = 0.0f;
            if (this.lyr.length < 1) {
                return;
            }
            int n = this.lyr.length - 1;
            int n2 = this.lyr[0].node.length;
            int n3 = this.lyr[n].node.length;
            float[] fArray = new float[n2];
            float[] fArray2 = new float[n3];
            float[] fArray3 = new float[n3];
            try {
                FileReader fileReader = string.length() == 0 ? new FileReader(FileDescriptor.in) : new FileReader(string);
                LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                FileOutputStream fileOutputStream = string2.length() == 0 ? new FileOutputStream(FileDescriptor.out) : new FileOutputStream(string2);
                PrintStream printStream = new PrintStream(fileOutputStream);
                try {
                    String string3;
                    while ((string3 = lineNumberReader.readLine()) != null) {
                        int n4;
                        block23: {
                            String string4;
                            StringTokenizer stringTokenizer = new StringTokenizer(string3);
                            try {
                                n4 = 0;
                                while (n4 < n2) {
                                    string4 = stringTokenizer.nextToken();
                                    fArray[n4] = Float.parseFloat(string4);
                                    ++n4;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                NNError.err("Missmatch value in input record ");
                            }
                            try {
                                n4 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    if (n4 <= n3 - 1) {
                                        string4 = stringTokenizer.nextToken();
                                        fArray3[n4] = Float.parseFloat(string4);
                                        ++n4;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!bl) break block23;
                                NNError.err("Missmatch value in train record ");
                            }
                        }
                        if (bl) {
                            f = this.ebplearnNNet(fArray, fArray2, fArray3);
                        } else {
                            this.frwNNet(fArray, fArray2);
                        }
                        if (bl2 | bl3) {
                            n4 = 0;
                            while (n4 < n2) {
                                printStream.print(fArray[n4] + " ");
                                ++n4;
                            }
                            printStream.print("    ");
                        }
                        if (bl3) {
                            n4 = 0;
                            while (n4 < n3) {
                                printStream.print(fArray3[n4] + " ");
                                ++n4;
                            }
                            printStream.print("    ");
                        }
                        n4 = 0;
                        while (n4 < n3) {
                            printStream.print(fArray2[n4] + " ");
                            ++n4;
                        }
                        printStream.println("");
                        if (!bl4) continue;
                        System.out.println(f);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (string.length() != 0) {
                        lineNumberReader.close();
                        fileReader.close();
                    }
                    if (string2.length() == 0) break block24;
                    printStream.close();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                NNError.err("File not found ");
            }
        }
    }

    public void ebpNNet(boolean bl, float f, float f2) {
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].ebpLayer(bl, f, f2);
            ++n;
        }
    }

    public void ebpNNet() {
        this.ebpNNet(NrPop.fbias, NrPop.eps, NrPop.alfa);
    }

    public float ebpNNet(float[] fArray, boolean bl, float f, float f2) {
        int n = fArray.length < this.lyr[this.lyr.length - 1].node.length ? fArray.length : this.lyr[this.lyr.length - 1].node.length;
        float f3 = this.lyr[this.lyr.length - 1].err(0, n, fArray);
        int n2 = this.lyr.length - 1;
        while (n2 >= 0) {
            this.lyr[n2].ebpLayer(bl, f, f2);
            --n2;
        }
        return f3;
    }

    public float ebpNNet(float[] fArray) {
        return this.ebpNNet(fArray, NeuralShoot.trainBias, NeuralShoot.learningRate, NeuralShoot.momentum);
    }

    public float ebplearnNNet(float[] fArray, float[] fArray2) {
        if (fArray2.length < this.lyr[this.lyr.length - 1].node.length) {
            int n = fArray.length;
        } else {
            int n = this.lyr[this.lyr.length - 1].node.length;
        }
        this.frwNNet(fArray);
        return this.ebpNNet(fArray2);
    }

    public float ebplearnNNet(float[] fArray, float[] fArray2, float[] fArray3) {
        if (fArray3.length < this.lyr[this.lyr.length - 1].node.length) {
            int n = fArray.length;
        } else {
            int n = this.lyr[this.lyr.length - 1].node.length;
        }
        this.frwNNet(fArray, fArray2);
        return this.ebpNNet(fArray3);
    }

    public float ebplearnNNet(String[] stringArray) {
        float f = 0.0f;
        if (stringArray.length < 1) {
            return f;
        }
        if (this.lyr.length < 1) {
            return f;
        }
        int n = this.lyr.length - 1;
        int n2 = this.lyr[0].node.length;
        int n3 = this.lyr[n].node.length;
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n3];
        int n4 = 0;
        while (n4 < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n4]);
            try {
                String string;
                int n5 = 0;
                while (n5 < n2) {
                    string = stringTokenizer.nextToken();
                    fArray[n5] = Float.parseFloat(string);
                    ++n5;
                }
                n5 = 0;
                while (n5 < n3) {
                    string = stringTokenizer.nextToken();
                    fArray2[n5] = Float.parseFloat(string);
                    ++n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                NNError.err("Missmatch value in train record " + n4);
            }
            this.frwNNet(fArray);
            f += this.ebpNNet(fArray2);
            ++n4;
        }
        return f / (float)stringArray.length;
    }

    public float ebplearnNNet(String string) {
        String[] stringArray = NrPop.fileToStrArray(string);
        if (stringArray != null) {
            return this.ebplearnNNet(stringArray);
        }
        return 0.0f;
    }

    public NNet cloneNNet() {
        NNet nNet = new NNet(this.lyr.length);
        int n = 0;
        while (n < this.lyr.length) {
            nNet.lyr[n] = this.lyr[n].cloneLayer();
            ++n;
        }
        n = 0;
        while (n < this.lyr.length) {
            int n2 = this.lyr[n].getnlBuff();
            if (n2 >= 0) {
                nNet.lyr[n].mbuff = nNet.lyr[n2];
            }
            ++n;
        }
        n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].cloneLink(nNet);
            ++n;
        }
        return nNet;
    }

    public void copyWNNet(NNet nNet) {
        int n = nNet.lyr.length < this.lyr.length ? nNet.lyr.length : this.lyr.length;
        int n2 = 0;
        while (n2 < n) {
            this.lyr[n2].copyWLayer(nNet.lyr[n2]);
            ++n2;
        }
    }

    public void inirandNNet(float f, float f2, boolean bl) {
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].inirandLayer(f, f2, bl);
            ++n;
        }
    }

    public void wgtmutNNet(float f, float f2, boolean bl) {
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].wgtmutLayer(f, f2, bl);
            ++n;
        }
    }

    public void wgtmutNNet(float f, boolean bl) {
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].wgtmutLayer(f, bl);
            ++n;
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.saveNNet(printStream, 1);
        printStream.close();
        return byteArrayOutputStream.toString();
    }

    public void saveNNet(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.saveNNet(printStream, 1);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("Impossible to create file " + string);
        }
    }

    public void saveNNet(PrintStream printStream, int n) {
        printStream.println(" ");
        printStream.println("NET " + n + " " + this.lyr.length);
        int n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].saveLayer(printStream);
            ++n2;
        }
        printStream.println(" ");
        n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].saveLink(printStream);
            printStream.println(" ");
            ++n2;
        }
        printStream.flush();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.lyr.length);
        int n = 0;
        while (n < this.lyr.length) {
            this.lyr[n].saveLayer(dataOutputStream);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].saveLink(dataOutputStream);
            ++n2;
        }
        dataOutputStream.flush();
    }

    public NNet(String string, boolean bl) {
        boolean bl2 = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.whitespaceChars(44, 44);
            streamTokenizer.whitespaceChars(58, 58);
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                return;
            }
            if (streamTokenizer.sval.equals("NET")) {
                try {
                    streamTokenizer.nextToken();
                    int n = (int)streamTokenizer.nval;
                }
                catch (IOException iOException) {
                    NNError.err("Error on net file");
                    return;
                }
            }
            this.loadNNet(streamTokenizer);
        }
        catch (FileNotFoundException fileNotFoundException) {
            NNError.err("File not found " + string);
        }
    }

    public NNet(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(58, 58);
        try {
            streamTokenizer.nextToken();
        }
        catch (IOException iOException) {
            return;
        }
        if (streamTokenizer.sval.equals("NET")) {
            try {
                streamTokenizer.nextToken();
                int n = (int)streamTokenizer.nval;
            }
            catch (IOException iOException) {
                NNError.err("Error on net file");
                return;
            }
        }
        this.loadNNet(streamTokenizer);
    }

    public NNet(DataInputStream dataInputStream) throws IOException {
        this.loadNNet(dataInputStream);
    }

    void loadNNet(StreamTokenizer streamTokenizer) {
        int n;
        try {
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
        }
        catch (IOException iOException) {
            NNError.err("Error on net file");
            return;
        }
        this.lyr = new Layer[n];
        int n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2] = this.loadLayer(streamTokenizer, this.lyr);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].loadLink(streamTokenizer, this.lyr);
            ++n2;
        }
    }

    void loadNNet(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.lyr = new Layer[n];
        int n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2] = this.loadLayer(dataInputStream, this.lyr);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.lyr.length) {
            this.lyr[n2].loadLink(dataInputStream, this.lyr);
            ++n2;
        }
    }

    Layer loadLayer(StreamTokenizer streamTokenizer, Layer[] layerArray) {
        int n;
        String string;
        int n2;
        int n3;
        int n4;
        try {
            streamTokenizer.nextToken();
            n4 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            n3 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            streamTokenizer.nextToken();
            n = (int)streamTokenizer.nval;
        }
        catch (IOException iOException) {
            NNError.err("Error on net file");
            return null;
        }
        Layer layer = n2 > 0 ? new Layer(n4, n3, n2, string) : new Layer(n4, n3, string);
        if (n >= 0) {
            layer.mbuff = layerArray[n];
        }
        return layer;
    }

    Layer loadLayer(DataInputStream dataInputStream, Layer[] layerArray) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        int n4 = dataInputStream.readInt();
        Layer layer = n3 > 0 ? new Layer(n, n2, n3, string) : new Layer(n, n2, string);
        if (n4 >= 0) {
            layer.mbuff = layerArray[n4];
        }
        return layer;
    }
}

