/*
 * Decompiled with CFR 0.152.
 */
package ags.rougedc.movement;

import ags.rougedc.movement.RobotDriver;
import ags.rougedc.robots.VirtualRobot;
import ags.rougedc.robots.VirtualRobotPredictor;
import ags.rougedc.waves.EnemyWave;
import ags.util.points.AbsolutePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import robocode.Rules;

public class SurfingPredictor
extends VirtualRobotPredictor {
    private final List<EnemyWave> waves;
    public final List<EnemyWave> passedWaves;
    public final RobotDriver driver;
    public final List<RobotDriver> drivers;
    public final Map<EnemyWave, double[]> waveDanger;
    public final AbsolutePoint fieldcorner;
    public final long timestart;

    public SurfingPredictor(VirtualRobot robot, RobotDriver driver, List<RobotDriver> drivers, List<EnemyWave> waves, Map<EnemyWave, double[]> waveDanger, List<EnemyWave> passedWaves, AbsolutePoint fieldcorner, long timestart) {
        super(robot, fieldcorner);
        this.fieldcorner = fieldcorner;
        this.driver = driver;
        this.drivers = drivers;
        this.timestart = timestart;
        this.waveDanger = new HashMap<EnemyWave, double[]>();
        this.waves = new ArrayList<EnemyWave>(waves.size());
        this.passedWaves = new ArrayList<EnemyWave>();
        for (EnemyWave wave : waves) {
            EnemyWave newwave = wave.clone();
            this.waves.add(newwave);
            if (passedWaves == null || !passedWaves.contains(wave)) continue;
            this.passedWaves.add(newwave);
        }
    }

    @Override
    public long getDeltaTime() {
        return super.getDeltaTime() + this.timestart;
    }

    @Override
    public double getAcceleration() {
        return this.driver.getAcceleration();
    }

    @Override
    public double getAngularVelocity() {
        return this.driver.getAngularVelocity();
    }

    public double getDanger(double maxdanger) {
        double danger = 0.0;
        while (this.waves.size() > 0 && danger <= maxdanger) {
            this.driver.run(this, this.waves);
            this.move();
            if (Double.isNaN(this.getLocation().x) || Double.isNaN(this.getLocation().y)) {
                System.out.println("Warning: Surfing encountered NaN!");
                return danger;
            }
            double tickweight = 1.0;
            boolean wavePassed = false;
            Iterator<EnemyWave> iter = this.waves.iterator();
            while (iter.hasNext()) {
                EnemyWave wave = iter.next();
                wave.move();
                wave.checkHit(this);
                double[][] dangerpoints = wave.getDangerPoints();
                double[] pointdanger = this.waveDanger.get(wave);
                if (pointdanger == null) {
                    pointdanger = new double[dangerpoints[1].length];
                    this.waveDanger.put(wave, pointdanger);
                }
                double waveweight = (Rules.getBulletDamage((double)wave.getPower()) - wave.getPower()) * tickweight;
                int x = 0;
                while (x < dangerpoints[1].length) {
                    double p = dangerpoints[0][x];
                    double pointweight = dangerpoints[1][x];
                    if (!(wave.getNewHitRange() == null || wave.getLastHitRange() != null && wave.getLastHitRange().intersects(p))) {
                        double distanceweight;
                        double thisdanger;
                        double distanceoutside = 10.0 * wave.getNewHitRange().distanceOutside(p);
                        if (distanceoutside > 0.0) {
                            distanceoutside += 1.0;
                        }
                        if ((thisdanger = pointweight * waveweight * (distanceweight = 1.0 / (1.0 + distanceoutside * distanceoutside))) > pointdanger[x]) {
                            danger += thisdanger - pointdanger[x];
                            pointdanger[x] = thisdanger;
                        }
                    }
                    ++x;
                }
                if (wave.getRadius() >= this.getLocation().distance(wave.getOrigin()) && !this.passedWaves.contains(wave)) {
                    this.passedWaves.add(wave);
                    wavePassed = true;
                }
                if (!wave.expired(this)) continue;
                iter.remove();
            }
            if (danger > maxdanger) {
                return danger;
            }
            if (!wavePassed) continue;
            double lowestDanger = maxdanger - danger;
            for (RobotDriver newdriver : this.drivers) {
                SurfingPredictor predictor = new SurfingPredictor(this, newdriver, this.drivers, this.waves, this.waveDanger, this.passedWaves, this.fieldcorner, this.getDeltaTime());
                double newdanger = predictor.getDanger(lowestDanger);
                if (!(newdanger < lowestDanger)) continue;
                lowestDanger = newdanger;
            }
            return danger += lowestDanger;
        }
        return danger;
    }
}

