/*
 * Decompiled with CFR 0.152.
 */
package az;

import az.displacementVector;
import az.displacementVectorData;
import az.util.Utils;

class treeNode {
    static final int MAX_SIZE = 512;
    static final int leftWallDistanceSeparator = 0;
    static final int bottomWallDistanceSeparator = 1;
    static final int headingSeparator = 2;
    static final int startVelocitySeparator = 3;
    static final int enemyCountSeparator = 4;
    static final int separatorCount = 5;
    static double width;
    static double height;
    int separator = -1;
    int size = 0;
    treeNode leftSon;
    treeNode rightSon;
    double separateValue;
    double[] leftBound = new double[5];
    double[] rightBound = new double[5];
    displacementVector[] vectors = new displacementVector[512];
    static double[] arr_MAX_SIZE;
    static Utils.changeEvent[] changeEventArr;

    static {
        arr_MAX_SIZE = new double[512];
        changeEventArr = new Utils.changeEvent[4106];
    }

    treeNode(double _width, double _height) {
        width = _width;
        height = _height;
        int i = 0;
        while (i < 5) {
            this.leftBound[i] = 0.0;
            this.rightBound[i] = 1.0;
            ++i;
        }
    }

    treeNode(double[] _leftBound, double[] _rightBound) {
        int i = 0;
        while (i < 5) {
            this.leftBound[i] = _leftBound[i];
            this.rightBound[i] = _rightBound[i];
            ++i;
        }
    }

    public void add(displacementVector vec) {
        if (this.separator == -1) {
            if (this.size == 512) {
                int position = (int)(Math.random() * 512.0 - 1.0E-9);
                this.vectors[position] = vec;
            } else {
                this.vectors[this.size++] = vec;
            }
            if (this.size == 512) {
                int bestSeparator = -1;
                double bestSmallestPartSize = -1.0;
                double bestSeparateValue = 0.0;
                int i = 0;
                while (i < 5) {
                    double smallestPartSize;
                    int j = 0;
                    while (j < this.size) {
                        treeNode.arr_MAX_SIZE[j] = this.getDataForSeparating(this.vectors[j], i);
                        ++j;
                    }
                    double centerLeft = Utils.findKth(arr_MAX_SIZE, 0, 511, 256);
                    double centerRight = Double.POSITIVE_INFINITY;
                    int j2 = 0;
                    while (j2 < this.size) {
                        if (arr_MAX_SIZE[j2] > centerLeft && arr_MAX_SIZE[j2] < centerRight) {
                            centerRight = arr_MAX_SIZE[j2];
                        }
                        ++j2;
                    }
                    double realCenter = (this.leftBound[i] + this.rightBound[i]) / 2.0;
                    this.separateValue = realCenter <= centerLeft ? centerLeft + 1.0E-9 : (realCenter >= centerRight ? centerRight - 1.0E-9 : realCenter);
                    int x = 0;
                    int j3 = 0;
                    while (j3 < this.size) {
                        if (arr_MAX_SIZE[j3] < this.separateValue) {
                            ++x;
                        }
                        ++j3;
                    }
                    if (x >= 128 && x <= 384 && (smallestPartSize = Math.min(this.separateValue - this.leftBound[i], this.rightBound[i] - this.separateValue)) > bestSmallestPartSize) {
                        bestSeparator = i;
                        bestSmallestPartSize = smallestPartSize;
                        bestSeparateValue = this.separateValue;
                    }
                    ++i;
                }
                if (bestSeparator == -1) {
                    return;
                }
                this.separator = bestSeparator;
                this.separateValue = bestSeparateValue;
                double tmp = this.rightBound[this.separator];
                this.rightBound[this.separator] = this.separateValue;
                this.leftSon = new treeNode(this.leftBound, this.rightBound);
                this.leftBound[this.separator] = this.separateValue;
                this.rightBound[this.separator] = tmp;
                this.rightSon = new treeNode(this.leftBound, this.rightBound);
                int i2 = 0;
                while (i2 < this.size) {
                    if (this.getDataForSeparating(this.vectors[i2], this.separator) < this.separateValue) {
                        this.leftSon.add(this.vectors[i2]);
                    } else {
                        this.rightSon.add(this.vectors[i2]);
                    }
                    ++i2;
                }
                this.leftBound = null;
                this.rightBound = null;
                this.vectors = null;
            }
            return;
        }
        treeNode node = this.findNode(vec);
        node.add(vec);
    }

    int addProbabilityChangeEvents(int offset, double alpha, double beta, double weight) {
        if ((alpha = robocode.util.Utils.normalAbsoluteAngle((double)alpha)) > (beta = robocode.util.Utils.normalAbsoluteAngle((double)beta))) {
            double tmp = alpha;
            alpha = beta;
            beta = tmp;
        }
        int cnt = 0;
        if (beta - alpha > Math.PI) {
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(beta, weight);
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(Math.PI * 2, -weight);
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(0.0, weight);
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(alpha, -weight);
        } else {
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(alpha, weight);
            treeNode.changeEventArr[offset + cnt++] = new Utils.changeEvent(beta, -weight);
        }
        return cnt;
    }

    Utils.changeEvent[] generateProbabilityChangeEventListForFiringAngles(displacementVector vec, double scanTime, double scanX, double scanY, double ourX, double ourY, double ourHeading, double ourVelocity, double timeNow, double timeAtFire, double bulletSpeed, int angleNormalizationMode) {
        if (this.separator == -1) {
            int j = 0;
            while (changeEventArr[j] != null) {
                treeNode.changeEventArr[j] = null;
                ++j;
            }
            ourX += ourVelocity * Math.sin(ourHeading) * (timeAtFire - timeNow);
            ourY += ourVelocity * Math.cos(ourHeading) * (timeAtFire - timeNow);
            int cnt = 0;
            int i = 0;
            while (i < this.size) {
                double vx = this.vectors[i].vx * this.vectors[i].vCoef;
                double vy = this.vectors[i].vy * this.vectors[i].vCoef;
                double dx = scanX + (timeAtFire - scanTime) * vx - ourX;
                double dy = scanY + (timeAtFire - scanTime) * vy - ourY;
                double t = Utils.intersectWaveWithLinearMovement(dx, dy, vx, vy, bulletSpeed, this.vectors[i].time);
                double predictedX = dx + vx * t;
                double predictedY = dy + vy * t;
                if (!(ourX + predictedX < 0.0 || ourX + predictedX > width || ourY + predictedY < 0.0 || ourY + predictedY > height)) {
                    double weight = 1.0 / Math.pow(0.9 + Math.max(0.1, Math.abs((double)this.vectors[i].time - t) / (double)this.vectors[i].time), 8.0);
                    double alpha = displacementVectorData.denormalizeAngle(Math.atan2(predictedX + (double)(this.vectors[i].vx * 24.0f), predictedY + (double)(this.vectors[i].vy * 24.0f)), angleNormalizationMode);
                    double beta = displacementVectorData.denormalizeAngle(Math.atan2(predictedX - (double)(this.vectors[i].vx * 12.0f), predictedY - (double)(this.vectors[i].vy * 12.0f)), angleNormalizationMode);
                    cnt += this.addProbabilityChangeEvents(cnt, alpha, beta, weight);
                    alpha = displacementVectorData.denormalizeAngle(Math.atan2(predictedX + (double)(this.vectors[i].vx * 42.0f), predictedY + (double)(this.vectors[i].vy * 42.0f)), angleNormalizationMode);
                    beta = displacementVectorData.denormalizeAngle(Math.atan2(predictedX - (double)(this.vectors[i].vx * 30.0f), predictedY - (double)(this.vectors[i].vy * 30.0f)), angleNormalizationMode);
                    cnt += this.addProbabilityChangeEvents(cnt, alpha, beta, weight);
                }
                ++i;
            }
            return changeEventArr;
        }
        treeNode node = this.findNode(vec);
        return node.generateProbabilityChangeEventListForFiringAngles(vec, scanTime, scanX, scanY, ourX, ourY, ourHeading, ourVelocity, timeNow, timeAtFire, bulletSpeed, angleNormalizationMode);
    }

    treeNode findNode(displacementVector vec) {
        if (this.separator == -1) {
            return this;
        }
        if (this.getDataForSeparating(vec, this.separator) < this.separateValue) {
            return this.leftSon.findNode(vec);
        }
        return this.rightSon.findNode(vec);
    }

    double getDataForSeparating(displacementVector vec, int separator) {
        if (separator == 0) {
            return vec.leftWallDistance;
        }
        if (separator == 1) {
            return vec.bottomWallDistance;
        }
        if (separator == 2) {
            return vec.startHeading;
        }
        if (separator == 3) {
            return vec.startVelocity;
        }
        if (separator == 4) {
            return vec.enemyCount;
        }
        return Double.NaN;
    }
}

