/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Stampede2;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;
import wcsv.Stampede2.ExperimentalGun;
import wcsv.Stampede2.SegmentData;
import wcsv.Stampede2.target;
import wcsv.Stampede2.wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExperimentalMove {
    public static ExperimentalGun enemyGun;
    public static double width;
    public static double height;
    public static double orbitDirection;
    public static final double diveThreshhold = 25.0;
    public static final double maxSpeed = 8.0;
    public static final double maxTurn = 10.0;
    public AdvancedRobot robot;
    public target myData;
    public target enemy;
    public target[] myPastData;
    public target enemyPastData;
    public RoundRectangle2D.Double fieldBounds;
    public Bullet bulletHit;
    public double lastFirePower;

    public void reset(AdvancedRobot r) {
        this.robot = r;
        width = r.getBattleFieldWidth();
        height = r.getBattleFieldHeight();
        this.fieldBounds = new RoundRectangle2D.Double(24.0, 24.0, width - 48.0, height - 48.0, 100.0, 100.0);
        this.enemy = null;
        this.myData = null;
        this.myPastData = new target[2];
        this.enemyPastData = null;
        enemyGun.clearLists();
    }

    public void enemyFiredBullet(double fp) {
        enemyGun.fireWave(this.myPastData[0] != null ? this.myPastData[0] : this.myData, this.enemyPastData.x, this.enemyPastData.y, this.enemyPastData.data.getHeading(), fp, this.myData.data.getTime() - (long)2);
        this.lastFirePower = 0.0;
    }

    public void hitByBullet() {
        this.incrementClosestWave(this.myData, this.bulletHit.getX(), this.bulletHit.getY());
        this.bulletHit = null;
    }

    public Point2D.Double projectPosition(wave w, int ticks, int orbitDir) {
        double nx = this.robot.getX();
        double ny = this.robot.getY();
        double angle = 0.0;
        double angleToTurn = 0.0;
        double v = this.robot.getVelocity();
        double heading = this.robot.getHeading();
        int dir = 1;
        int i = 0;
        while (i < ticks) {
            double offset = 4000.0 / target.calcDistance(nx, ny, w.sourceX, w.sourceY) + 90.0;
            angle = this.getWallCorrectedAngle(nx, ny, target.normalAbsoluteAngle(target.absbearing(nx, ny, w.sourceX, w.sourceY) - offset * (double)orbitDir), orbitDir);
            angleToTurn = target.normalRelativeAngle(angle - heading);
            dir = Math.abs(angleToTurn) > 90.0 ? -1 : 1;
            double tr = 10.0 - 0.75 * Math.abs(v);
            if (angleToTurn < 0.0) {
                heading += Math.min(tr, Math.abs(angleToTurn));
            } else if (angleToTurn > 0.0) {
                heading -= Math.min(tr, Math.abs(angleToTurn));
            }
            heading = target.normalAbsoluteAngle(heading);
            v = dir == 1 ? (v < 0.0 ? (v += (double)2) : Math.min(8.0, v + 1.0)) : (v > 0.0 ? (v -= (double)2) : Math.max(-8.0, v - 1.0));
            nx = target.calcX(nx, heading, v);
            ny = target.calcY(ny, heading, v);
            ++i;
        }
        return new Point2D.Double(nx, ny);
    }

    public void doMove(target en) {
        wave w = this.getClosestWave(this.myData);
        if (w == null) {
            return;
        }
        double offset = 4000.0 / target.calcDistance(this.myData.x, this.myData.y, w.sourceX, w.sourceY) + 90.0;
        double abs = target.absbearing(this.myData.x, this.myData.y, w.sourceX, w.sourceY);
        double bearing_relative_CW = this.getWallCorrectedAngle(this.myData.x, this.myData.y, target.normalAbsoluteAngle(abs - offset), 1);
        double nx = target.calcX(this.myData.x, bearing_relative_CW, 10.0);
        double ny = target.calcY(this.myData.y, bearing_relative_CW, 10.0);
        Point2D.Double ncw = this.projectPosition(w, w.timeUntilHit(this.myData), 1);
        bearing_relative_CW = w.bearingChange(ncw.getX(), ncw.getY(), this.myData);
        double bearing_relative_CCW = this.getWallCorrectedAngle(this.myData.x, this.myData.y, target.normalAbsoluteAngle(abs + offset), -1);
        double nx1 = target.calcX(this.myData.x, bearing_relative_CCW, 10.0);
        double ny1 = target.calcY(this.myData.y, bearing_relative_CCW, 10.0);
        Point2D.Double nccw = this.projectPosition(w, w.timeUntilHit(this.myData), -1);
        bearing_relative_CCW = w.bearingChange(nccw.getX(), nccw.getY(), this.myData);
        double wantedAngleCW = target.absbearing(this.myData.x, this.myData.y, nx, ny);
        double wantedAngleCCW = target.absbearing(this.myData.x, this.myData.y, nx1, ny1);
        double cwd = this.getHitsAtBearing(w.enemy, w, target.normalRelativeAngle(Math.toDegrees(w.bearingChange(this.myData)) + bearing_relative_CW)) + 1.0;
        double ccwd = this.getHitsAtBearing(w.enemy, w, target.normalRelativeAngle(Math.toDegrees(w.bearingChange(this.myData)) + bearing_relative_CCW)) + 1.0;
        cwd /= Math.pow(target.calcDistance(ncw.getX(), ncw.getY(), this.enemy.x, this.enemy.y), 1.3);
        ccwd /= Math.pow(target.calcDistance(nccw.getX(), nccw.getY(), this.enemy.x, this.enemy.y), 1.3);
        double wantedAngle = 0.0;
        if (cwd < ccwd) {
            wantedAngle = wantedAngleCW;
            orbitDirection = 1.0;
        } else if (cwd > ccwd) {
            wantedAngle = wantedAngleCCW;
            orbitDirection = -1.0;
        } else {
            wantedAngle = orbitDirection == 1.0 ? wantedAngleCW : wantedAngleCCW;
        }
        this.move(target.normalRelativeAngle(wantedAngle - this.robot.getHeading()), 100.0);
    }

    public double getWallCorrectedAngle(double x, double y, double wantedAngle, int sign) {
        wantedAngle = Math.toRadians(wantedAngle);
        while (!this.fieldBounds.contains(x + Math.sin(wantedAngle) * 120.0, y + Math.cos(wantedAngle) * 120.0)) {
            wantedAngle += (double)sign * 0.1;
        }
        return target.normalAbsoluteAngle(Math.toDegrees(wantedAngle));
    }

    public void move(double angle, double distance) {
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.robot.setTurnRight(angle);
        this.robot.setAhead(distance);
    }

    public void refresh(target en) {
        this.enemyPastData = this.enemy != null ? this.enemy.cloneTarget() : null;
        this.enemy = en.cloneTarget();
        this.myPastData[0] = this.myPastData[1] != null ? this.myPastData[1].cloneTarget() : null;
        this.myPastData[1] = this.myData != null ? this.myData.cloneTarget() : null;
        ScannedRobotEvent myScan = new ScannedRobotEvent(this.robot.getName(), this.robot.getEnergy(), Math.toRadians(target.normalAbsoluteAngle(en.bearing - 180.0)), en.data.getDistance(), Math.toRadians(this.robot.getHeading()), this.robot.getVelocity());
        myScan.setTime(en.data.getTime());
        if (this.myData == null) {
            this.myData = new target(myScan, en.data.getHeading(), en.x, en.y);
        } else {
            this.myData.refresh(myScan, en.data.getHeading(), en.x, en.y);
        }
        this.myData.bearing = this.myData.data.getBearing();
        this.myData.x = this.robot.getX();
        this.myData.y = this.robot.getY();
    }

    public void testWaveCompletion() {
        this.testWaves(this.myData, false);
    }

    public void incrementClosestWave(target t, double x, double y) {
        if (ExperimentalMove.enemyGun.waves.size() == 0) {
            return;
        }
        wave closest = (wave)ExperimentalMove.enemyGun.waves.get(0);
        long time = t.data.getTime();
        int s = ExperimentalMove.enemyGun.waves.size();
        int i = s - 1;
        while (i >= 0) {
            wave w = (wave)ExperimentalMove.enemyGun.waves.get(i);
            double dist = target.calcDistance(w.sourceX, w.sourceY, x, y);
            double closestDist = target.calcDistance(closest.sourceX, closest.sourceY, x, y);
            if (Math.abs(w.radius(time) - dist) < Math.abs(closest.radius(time) - closestDist)) {
                closest = w;
            }
            --i;
        }
        enemyGun.processWave(closest, t);
    }

    public wave getClosestWave(target t) {
        if (ExperimentalMove.enemyGun.waves.size() == 0) {
            return null;
        }
        wave closest = (wave)ExperimentalMove.enemyGun.waves.get(0);
        long time = t.data.getTime();
        int s = ExperimentalMove.enemyGun.waves.size();
        int i = s - 1;
        while (i >= 0) {
            wave w = (wave)ExperimentalMove.enemyGun.waves.get(i);
            double dist = target.calcDistance(w.sourceX, w.sourceY, t.x, t.y);
            double closestDist = target.calcDistance(closest.sourceX, closest.sourceY, t.x, t.y);
            double wRad = w.radius(time);
            double cRad = closest.radius(time);
            if (cRad > closestDist || wRad < dist && Math.abs(wRad - dist) < Math.abs(cRad - closestDist)) {
                closest = w;
            }
            --i;
        }
        return closest;
    }

    public double getHitsAtBearing(target t, wave closest, double deltaBearing) {
        SegmentData fullSeg = ExperimentalMove.enemyGun.fullSeg;
        SegmentData lowSeg = ExperimentalMove.enemyGun.lowSeg;
        fullSeg.setIndexData(t, closest.velocity);
        lowSeg.setIndexData(t, closest.velocity);
        double[] fullStats = fullSeg.buffer[fullSeg.DistanceIndex][fullSeg.AccelIndex][fullSeg.LateralIndex][fullSeg.AdvancingIndex][fullSeg.WallIndex];
        double[] lowStats = lowSeg.buffer[lowSeg.DistanceIndex][lowSeg.AccelIndex][lowSeg.LateralIndex][lowSeg.AdvancingIndex][lowSeg.WallIndex];
        int index = ExperimentalGun.getBin(Math.toRadians(deltaBearing) / ExperimentalGun.MAX_BEARING);
        double smoothed = 0.0;
        int i = 0;
        while (i < 41) {
            smoothed += (fullStats[i] + lowStats[i]) / Math.pow((double)Math.abs(index - i) + 1.0, 2);
            ++i;
        }
        return smoothed;
    }

    public void testWaves(target t, boolean process) {
        int s = ExperimentalMove.enemyGun.waves.size();
        int i = 0;
        while (i < s) {
            wave w = (wave)ExperimentalMove.enemyGun.waves.get(i);
            if (w.radius(this.myData.data.getTime()) - 100.0 < target.calcDistance(w.sourceX, w.sourceY, t.x, t.y)) {
                ExperimentalMove.enemyGun.liveWaves.add(w);
            }
            ++i;
        }
        ExperimentalMove.enemyGun.waves.clear();
        ExperimentalMove.enemyGun.waves = (Vector)ExperimentalMove.enemyGun.liveWaves.clone();
        ExperimentalMove.enemyGun.liveWaves.clear();
    }

    private final /* synthetic */ void this() {
        this.myPastData = new target[2];
        this.bulletHit = null;
        this.lastFirePower = 0.0;
    }

    public ExperimentalMove() {
        this.this();
        enemyGun = new ExperimentalGun(false);
    }

    static {
        orbitDirection = 1.0;
    }
}

