/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.utils.DVektor;
import alk.lap.utils.RollingHistory;
import alk.lap.utils.VirtualCanvas;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitDistanceStatistic {
    public static final int SEGMENTATION = 15;
    public static final int MAX_VALUE = 800;
    public static final int STAT_SIZE = 106;
    public int[] hitsAtDistance = new int[106];
    private int count = 0;

    public HitDistanceStatistic() {
        int i = 0;
        while (i < this.hitsAtDistance.length) {
            this.hitsAtDistance[i] = 0;
            ++i;
        }
    }

    public void incAtDistance(double distance) {
        int n = HitDistanceStatistic.indexOf(distance);
        this.hitsAtDistance[n] = this.hitsAtDistance[n] + 1;
        ++this.count;
    }

    public int getHitsAt(double distance) {
        return this.hitsAtDistance[HitDistanceStatistic.indexOf(distance)];
    }

    public int getHitsAt(int index) {
        return this.hitsAtDistance[index];
    }

    public int getCount() {
        return this.count;
    }

    private static int indexOf(double distance) {
        return (int)((distance + 800.0) / 15.0);
    }

    public static double distanceOf(int index) {
        return (double)(index * 15 - 800) + 7.5;
    }

    public static void paintDistStat(LoudAndProud proud, RollingHistory<HitDistanceStatistic> stat, Color color, String name, int index) {
        VirtualCanvas vc = proud.getVc();
        AnalystsDatabase db = proud.getStrategicLead().getAnalystsDB();
        AnalystsDatabase.StatMax max = db.getMostLikelyDistance(stat, 0.0);
        double factor = max.score == 0.0 ? 1.0 : 200.0 / max.score;
        double paintedDistSegment = 300.0;
        int fromIndex = HitDistanceStatistic.indexOf(-paintedDistSegment);
        int toIndex = HitDistanceStatistic.indexOf(paintedDistSegment);
        double statWidth = 700.0;
        double start = 50.0;
        double yPos = 25.0;
        double distanceBetweenDots = statWidth / (double)(toIndex - fromIndex);
        DVektor previous = new DVektor(start, yPos);
        int i = fromIndex;
        while (i < toIndex) {
            double distScore = db.getDistanceScore(HitDistanceStatistic.distanceOf(i), stat);
            DVektor current = new DVektor(start + (double)(i - fromIndex) * distanceBetweenDots, distScore * factor + yPos);
            vc.drawLine(previous, current, "", color);
            if (distScore == max.score && max.score != 0.0) {
                vc.drawLine(new DVektor(current.getIntX(), yPos - 7.0 + (double)(index * 10)), current, "max at " + HitDistanceStatistic.distanceOf(i) + " with " + distScore, color);
            }
            previous = current;
            ++i;
        }
    }
}

