/*
 * Decompiled with CFR 0.152.
 */
package knackibot;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MyUtils {
    public static double angleBetween(Point2D.Double center, Point2D.Double next, Point2D.Double previous) {
        double angle = Math.atan2(next.getX() - center.getX(), next.getY() - center.getY()) - Math.atan2(previous.getX() - center.getX(), previous.getY() - center.getY());
        return angle;
    }

    public static Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    public static double calcAbsBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double roundDouble(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static boolean isInsideBattleField(Point2D.Double p, double margin) {
        return p.x > 0.0 + margin && p.x < 800.0 + margin && p.y > 0.0 + margin && p.y < 600.0 + margin;
    }

    public static double getBulletDamage(double firepower) {
        return 4.0 * firepower + 2.0 * Math.max(firepower - 1.0, 0.0);
    }

    public static double getBulletVelocity(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    public static double maxEscapeAngle(double firepower) {
        return Math.asin(8.0 / MyUtils.getBulletVelocity(firepower));
    }
}

