/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import lazarecki.robot.painter.PainterModule;
import lazarecki.util.RoboUtils;
import lazarecki.wave.Wave;
import robocode.util.Utils;

public abstract class AbstractWavePainterModule
extends PainterModule {
    private Color waveColor;

    public AbstractWavePainterModule() {
        this.setWaveColor(RoboUtils.cloneTransparentColor(Color.LIGHT_GRAY, 64));
    }

    public Color getWaveColor() {
        return this.waveColor;
    }

    public void setWaveColor(Color waveColor) {
        this.waveColor = waveColor;
    }

    protected void onPaintWave(Graphics2D g, Wave wave) {
        g.setColor(this.getWaveColor());
        double waveDistance = wave.getDistanceTraveled(this.getRobot().getTime());
        Line2D.Double bulletPath = new Line2D.Double(RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteFireAngle(), 35.0), RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteFireAngle(), 35.0 + Math.max(waveDistance - 35.0, 0.0)));
        Point2D bulletPoint = RoboUtils.projectPoint(wave.getShooter().getPosition(), wave.getAbsoluteFireAngle(), waveDistance);
        Ellipse2D.Double bulletCircle = new Ellipse2D.Double(bulletPoint.getX() - 10.0, bulletPoint.getY() - 10.0, 20.0, 20.0);
        Arc2D.Double waveArc = new Arc2D.Double(wave.getShooter().getPosition().getX() - waveDistance, wave.getShooter().getPosition().getY() - waveDistance, 2.0 * waveDistance, 2.0 * waveDistance, 360.0 * Utils.normalAbsoluteAngle((double)(wave.getAbsoluteFireAngle() - wave.getMaxEscapeAngle() - 1.5707963267948966)) / (Math.PI * 2), 360.0 * Utils.normalAbsoluteAngle((double)(2.0 * wave.getMaxEscapeAngle())) / (Math.PI * 2), 2);
        g.draw(bulletPath);
        g.draw(waveArc);
        g.draw(bulletCircle);
    }
}

