/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.AttractorPointModule;
import lazarecki.util.RoboUtils;
import robocode.StatusEvent;
import robocode.util.Utils;

public class RepulsorPointModule
extends AttractorPointModule {
    private double absStartAngle;
    private double absExtentAngle;
    private double maxRepulsionDistance;

    public RepulsorPointModule(Point2D location, double absStartAngle, double absExtentAngle, double maxRepulsionDistance) {
        super(location);
        this.absStartAngle = absStartAngle;
        this.absExtentAngle = absExtentAngle;
        this.maxRepulsionDistance = maxRepulsionDistance;
    }

    public RepulsorPointModule(Point2D location, double maxRepulsionDistance) {
        this(location, 0.0, Math.PI * 2, maxRepulsionDistance);
    }

    public double getAbsoluteStartAngle() {
        return this.absStartAngle;
    }

    public double getAbsoluteExtentAngle() {
        return this.absExtentAngle;
    }

    public double getMaxRepulsionDistance() {
        return this.maxRepulsionDistance;
    }

    @Override
    public void onStatus(StatusEvent event) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        double absBearing = RoboUtils.projectAbsoluteAngle(this.getLocation(), myInfo.getPosition());
        double bearing = Utils.normalAbsoluteAngle((double)(absBearing - this.getAbsoluteStartAngle()));
        if (bearing > this.getAbsoluteExtentAngle()) {
            return;
        }
        double distance = myInfo.distance(this.getLocation());
        if (distance > this.getMaxRepulsionDistance()) {
            return;
        }
        Point2D attractor = RoboUtils.projectPoint(myInfo, absBearing, 2.0 * (this.getMaxRepulsionDistance() - distance));
        this.getRobot().setDestination(attractor);
    }
}

