/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentBase;
import pedersen.tactics.grail.SegmentLateralVelocityImpl;
import pedersen.tactics.targeting.TargetingMethod;

public class SegmentAccelerationImpl
extends SegmentBase
implements Segment {
    private static final double maximumValue = 2.0;
    private static final int maxBinSize = 2;

    public SegmentAccelerationImpl() {
        super(2.0, 2);
        this.zero = new SegmentLateralVelocityImpl();
        this.positive = new SegmentLateralVelocityImpl[0];
        this.negative = new SegmentLateralVelocityImpl[0];
        this.buildOrganicBins();
    }

    protected void buildOrganicBins() {
        if (this.positiveBinSize != this.positive.length) {
            this.positive = new SegmentLateralVelocityImpl[this.positiveBinSize];
            int i = 0;
            while (i < this.positiveBinSize) {
                this.positive[i] = new SegmentLateralVelocityImpl();
                ++i;
            }
            Iterator iterator = this.positiveWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
        if (this.negativeBinSize != this.negative.length) {
            this.negative = new SegmentLateralVelocityImpl[this.negativeBinSize];
            int i = 0;
            while (i < this.negativeBinSize) {
                this.negative[i] = new SegmentLateralVelocityImpl();
                ++i;
            }
            Iterator iterator = this.negativeWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
    }

    public void addWaveData(WaveData waveData) {
        super.addWaveData(waveData, waveData.originalAcceleration);
    }

    public void addWaveDataBypass(WaveData waveData) {
        super.addWaveDataBypass(waveData, waveData.originalAcceleration);
    }

    public double getMostVisitedBearingOffset(WaveData waveData) {
        return super.getMostVisitedBearingOffset(waveData, waveData.originalAcceleration);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData) {
        return super.getLeastVisitedBearingOffset(waveData, waveData.originalAcceleration);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return super.getMostVisitedLinearProjection(waveData, waveData.originalAcceleration);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        return super.getFavoredTargetingMethod(waveData, waveData.originalAcceleration);
    }
}

