/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.AbstractPredictor;
import tcf.PredState;
import tcf.Prediction;
import tcf.StaticStore;

class SimplePredictor
extends AbstractPredictor {
    int[] m_hits = new int[]{1, 1, 1};
    int[] m_total = new int[]{1, 1, 1};

    SimplePredictor(String string) {
        if (StaticStore.get("SimplePredictor.hits." + string) != null) {
            this.m_hits = (int[])StaticStore.get("SimplePredictor.hits." + string);
            this.m_total = (int[])StaticStore.get("SimplePredictor.total." + string);
        } else {
            StaticStore.put("SimplePredictor.hits." + string, this.m_hits);
            StaticStore.put("SimplePredictor.total." + string, this.m_total);
        }
    }

    public Object predict(PredState predState, Prediction prediction) {
        prediction.clear();
        double d = predState.calcGfFromPos(predState.m_target.x(), predState.m_target.y());
        prediction.addGf(d, (double)this.m_hits[0] / (double)this.m_total[0]);
        double[] dArray = new double[2];
        predState.m_arena.linearPrediction(predState.m_target, predState.m_gun, predState.m_shotSpeed, dArray);
        double d2 = predState.calcGfFromPos(dArray[0], dArray[1]);
        prediction.addGf(d2, (double)this.m_hits[1] / (double)this.m_total[1]);
        predState.m_arena.circularPrediction(predState.m_target, predState.m_gun, predState.m_shotSpeed, dArray);
        double d3 = predState.calcGfFromPos(dArray[0], dArray[1]);
        prediction.addGf(d3, (double)this.m_hits[2] / (double)this.m_total[2]);
        return new double[]{d, d2, d3};
    }

    public void learn(PredState predState, PredState predState2, Object object, double d, boolean bl) {
        if (object instanceof double[] && bl) {
            double[] dArray = (double[])object;
            for (int i = 0; i < 3; ++i) {
                this.learn(i, Math.abs(d - dArray[i]) < 0.05);
            }
        }
    }

    private void learn(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.m_hits[n2] = this.m_hits[n2] + 1;
        }
        int n3 = n;
        this.m_total[n3] = this.m_total[n3] + 1;
    }
}

