/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Angle;
import benhorner.utility.units.Heading;
import benhorner.utility.units.Units;
import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bearing
implements Continuum<Bearing>,
AbsoluteToRelative<Bearing, Bearing> {
    private Angle angle;

    public static Angle normalizeRelativeAngle(Angle d) {
        Angle result = Heading.normalizeAbsoluteAngle(d.add(Units.HALF_CIRCLE)).subtract(Units.HALF_CIRCLE);
        assert (result.toDouble() >= -180.0);
        assert (result.toDouble() < 180.0);
        return result;
    }

    public Bearing(Angle angle) {
        this.angle = Bearing.normalizeRelativeAngle(angle);
    }

    public Bearing(double bearing_degrees) {
        this(new Angle(bearing_degrees));
    }

    @Override
    public Bearing negate() {
        return new Bearing(this.angle.negate());
    }

    @Override
    public Bearing add(Bearing bearing) {
        return new Bearing(this.angle.add(bearing.angle));
    }

    @Override
    public Bearing add(double bearing_degrees) {
        return this.add(new Bearing(bearing_degrees));
    }

    @Override
    public Bearing subtract(Bearing bearing) {
        return new Bearing(this.angle.subtract(bearing.angle));
    }

    @Override
    public Bearing subtract(double bearing_degrees) {
        return this.subtract(new Bearing(bearing_degrees));
    }

    @Override
    public Bearing multiply(double d) {
        return new Bearing(this.angle.multiply(d));
    }

    @Override
    public Bearing divide(double d) {
        return new Bearing(this.angle.divide(d));
    }

    @Override
    public double divide(Bearing bearing) {
        return this.angle.toDouble() / bearing.angle.toDouble();
    }

    public Angle toAngle() {
        return this.angle;
    }

    public double toDegrees() {
        return this.angle.toDegrees();
    }

    public double toRadians() {
        return this.angle.toRadians();
    }

    @Override
    public double toDouble() {
        return this.angle.toDouble();
    }

    public String toString() {
        return this.angle.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Bearing bearing = (Bearing)o;
            return bearing.angle.equals(this.angle);
        }
        return result;
    }

    public int hashCode() {
        return this.angle.hashCode();
    }
}

