/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Angle;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Units;
import benhorner.utility.units.interfaces.AbsoluteToRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heading
implements AbsoluteToRelative<Heading, Bearing> {
    private Angle angle;

    public static Angle normalizeAbsoluteAngle(Angle d) {
        double circles = Math.floor(d.divide(Units.FULL_CIRCLE));
        Angle result = d.subtract(Units.FULL_CIRCLE.multiply(circles));
        assert (result.toDouble() >= 0.0);
        assert (result.toDouble() < Units.FULL_CIRCLE.toDouble());
        return result;
    }

    public Heading(Angle angle) {
        this.angle = Heading.normalizeAbsoluteAngle(angle);
    }

    public Heading(double heading_degrees) {
        this(new Angle(heading_degrees));
    }

    @Override
    public Heading add(Bearing bearing) {
        return new Heading(this.angle.add(bearing.toAngle()));
    }

    @Override
    public Heading add(double bearing) {
        return this.add(new Bearing(bearing));
    }

    @Override
    public Bearing subtract(Heading heading) {
        return new Bearing(this.angle.subtract(heading.angle));
    }

    public Heading opposite() {
        return new Heading(this.angle.add(180.0));
    }

    public Angle toAngle() {
        return this.angle;
    }

    public double toDegrees() {
        return this.angle.toDegrees();
    }

    public double toRadians() {
        return this.angle.toRadians();
    }

    public Bearing getBearingTo(Heading heading) {
        return new Bearing(heading.angle.subtract(this.angle));
    }

    public Bearing getBearingFrom(Heading heading) {
        return heading.getBearingTo(this);
    }

    public String toString() {
        return this.angle.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Heading heading = (Heading)o;
            result = heading.angle.equals(this.angle);
        }
        return result;
    }

    public int hashCode() {
        return this.angle.hashCode();
    }
}

