/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import jwirde.Vect;
import jwirde.VectPol;
import robocode.util.Utils;

public class CoordUtils {
    public static Point2D getCoordFromBearing(Point2D startCoord, VectPol vectorPol) {
        double x = startCoord.getX() + Math.sin(vectorPol.angle) * vectorPol.magnitude;
        double y = startCoord.getY() + Math.cos(vectorPol.angle) * vectorPol.magnitude;
        return new Point2D.Double(x, y);
    }

    public static double getRelativeAngle(Point2D startCoord, Point2D targetCoord, double myAngle) {
        double angle = -1.5707963267948966 - Math.atan2(startCoord.getY() - targetCoord.getY(), startCoord.getX() - targetCoord.getX());
        return Utils.normalRelativeAngle((double)(angle - myAngle));
    }

    public static void drawRobotPosition(Graphics2D g, Color color, Point2D coord) {
        g.setColor(color);
        g.drawRect((int)coord.getX() - 25, (int)coord.getY() - 25, 50, 50);
    }

    public static void drawLineBetweenCoords(Graphics2D g, Color color, Point2D coord1, Point2D coord2) {
        g.setColor(color);
        g.drawLine((int)coord1.getX(), (int)coord1.getY(), (int)coord2.getX(), (int)coord2.getY());
    }

    public static void drawVect(Graphics2D g, Color color, Point2D coord, VectPol vectorPol) {
        g.setColor(color);
        Vect vect = vectorPol.asVect();
        Point2D.Double endCoord = new Point2D.Double(coord.getX() + vect.deltax, coord.getY() + vect.deltay);
        g.drawLine((int)coord.getX(), (int)coord.getY(), (int)((Point2D)endCoord).getX(), (int)((Point2D)endCoord).getY());
    }
}

