/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.Iterator;
import robocode.AdvancedRobot;
import taqho.GameInfo;
import taqho.Location;
import taqho.Logger;
import taqho.MathUtils;
import taqho.RobotData;
import taqho.ScanManager;

public class MoveManager {
    protected AdvancedRobot robot = null;
    protected ScanManager scanner = null;
    private Location location = null;
    private double distanceRemaining = 0.0;
    private double heading = 0.0;
    private double velocity = 8.0;
    private int direction = 1;
    private double newHeading = 0.0;
    private double newDistance = 0.0;
    private double newVelocity = 8.0;
    private boolean dirty = false;
    private boolean moveComplete = false;
    static final int MS_NONE = -1;
    static final int MS_STILL = 0;
    static final int MS_ANTIGRAV1 = 1;
    static final int MS_SPIN = 2;
    static final int MS_TARGET_PERPENDICULAR = 3;
    private int moveStrategy = -1;
    private int moveCount = 0;
    private int moveTicks = 1;
    private int moveDirection = 1;
    private double moveTurnLeft = 0.0;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public MoveManager() {
        this.robot = GameInfo.getRobot();
        this.robot.setMaxVelocity(8.0);
        this.location = new Location();
        this.moveStrategy = -1;
        this.moveCount = 0;
        this.moveDirection = 1;
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void updateTick() {
        this.location.Set(this.robot.getX(), this.robot.getY());
        this.distanceRemaining = this.robot.getDistanceRemaining();
        this.heading = this.robot.getHeading();
        this.newVelocity = this.velocity = this.robot.getVelocity();
        this.newDistance = this.distanceRemaining;
        this.newHeading = this.heading;
        this.moveComplete = this.robot.getTurnRemaining() == 0.0 && this.distanceRemaining == 0.0;
        this.dirty = false;
    }

    public void handleMove() {
        if (this.moveComplete && this.scanner != null) {
            if (this.moveCount % this.moveTicks == 0) {
                this.moveStrategy = this.selectMoveStrategy();
            }
            ++this.moveCount;
            if (this.moveStrategy == 0) {
                this.moveStill();
            }
            if (this.moveStrategy == 1) {
                this.moveAntiGrav1();
            }
            if (this.moveStrategy == 2) {
                this.moveSpin();
            }
            if (this.moveStrategy == 3) {
                this.moveTargetPerpendicular();
            }
        }
        if (this.dirty) {
            if (this.newDistance != 0.0 && this.newVelocity == 0.0) {
                this.newVelocity = 8.0;
            }
            this.robot.setMaxVelocity(this.newVelocity);
            this.direction = this.turnToHeading(this.newHeading);
            this.robot.setAhead(this.newDistance * (double)this.direction);
        }
    }

    public int selectMoveStrategy() {
        double select = Math.random() * 4.0;
        if (select > 3.0) {
            this.log("Move: Still");
            this.moveTicks = 9;
            return 0;
        }
        if (select > 2.0) {
            this.log("Move: Perpendicular");
            this.moveTicks = 25 + (int)(Math.random() * 15.0);
            return 3;
        }
        if (select > 1.0) {
            this.log("Move: Spin");
            this.moveTicks = 5;
            return 2;
        }
        this.log("Move: AntiGrav");
        this.moveTicks = 25 + (int)(Math.random() * 25.0);
        return 1;
    }

    public void moveStill() {
        this.setNewDistance(0.0);
        this.setNewHeading(this.heading);
    }

    public void moveSpin() {
        this.setNewVelocity(5.0);
        this.setNewDistance(150.0);
        this.setNewHeading(this.heading + 90.0);
    }

    public void moveTargetPerpendicular() {
        RobotData r = GameInfo.getScanner().getCurrentTarget();
        if (r != null) {
            this.setNewVelocity(8.0);
            if (this.moveCount % 5 == 0) {
                this.moveDirection *= -1;
            }
            this.setNewDistance(30 * this.moveDirection);
            double m = r.distance > 250.0 ? (this.moveDirection > 0 ? 30.0 : 150.0) : (r.distance < 200.0 ? (this.moveDirection > 0 ? 150.0 : 30.0) : 90.0);
            double nh = this.heading + r.getBearingToMeVal() + m;
            this.setNewHeading(nh);
        }
    }

    void moveAntiGrav1() {
        double dX = 0.0;
        double dY = 0.0;
        int numRobots = GameInfo.getOthers();
        double x = this.location.GetX();
        double y = this.location.GetY();
        double xmax = GameInfo.battleFieldWidth;
        double ymax = GameInfo.battleFieldHeight;
        double HALFPI = 1.5707963267948966;
        int distanceFactor = 2;
        Iterator robotIter = this.scanner.getOtherBots().values().iterator();
        while (robotIter.hasNext()) {
            RobotData r = (RobotData)robotIter.next();
            double rx = r.location.GetX();
            double ry = r.location.GetY();
            double force = (double)r.getAntiGravRepulsion() / Math.pow(Point2D.distance(x, y, rx, ry), distanceFactor);
            double forceBearing = MathUtils.normaliseBearing(1.5707963267948966 - Math.atan2(y - ry, x - rx));
            double rdx = Math.sin(forceBearing) * force;
            double rdy = Math.cos(forceBearing) * force;
            dX += rdx;
            dY += rdy;
        }
        double wallX = 0.0;
        double wallY = 0.0;
        wallX += 5000.0 / Math.pow(Point2D.distance(x, y, xmax, y), 3.0);
        wallY += 5000.0 / Math.pow(Point2D.distance(x, y, x, ymax), 3.0);
        double gotoX = x - (wallX -= 5000.0 / Math.pow(Point2D.distance(x, y, 0.0, y), 3.0)) - dX;
        double gotoY = y - (wallY -= 5000.0 / Math.pow(Point2D.distance(x, y, x, 0.0), 3.0)) - dY;
        this.moveTowards(gotoX, gotoY);
        this.setNewVelocity(8.0);
    }

    void moveTowards(double x, double y) {
        double myX = this.location.GetX();
        double myY = this.location.GetY();
        if (x == myX && y == myY) {
            return;
        }
        double bearing = MathUtils.bearingBetweenPointsDegrees(myX, myY, x, y);
        this.setNewHeading(bearing);
        this.setNewDistance(80.0 + Math.random() * 80.0 - 40.0);
    }

    public int turnToHeading(double newHeading) {
        double turn = MathUtils.normaliseBearingDegrees(this.heading - newHeading);
        int newDir = 1;
        if (turn > 90.0) {
            turn -= 90.0;
            newDir = -1;
        } else if (turn < -90.0) {
            turn += 90.0;
            newDir = -1;
        }
        this.robot.setTurnLeft(turn);
        this.moveTurnLeft = turn;
        return newDir;
    }

    public void setNewHeading(double h) {
        if (h != this.newHeading) {
            this.newHeading = h;
            this.dirty = true;
        }
    }

    public void setNewDistance(double d) {
        if (this.newDistance != d) {
            this.newDistance = d;
            this.dirty = true;
        }
    }

    public void setNewVelocity(double v) {
        if (this.newVelocity != v) {
            this.newVelocity = v;
            this.dirty = true;
        }
    }

    public void log(String msg) {
        Logger.log("MM: " + msg);
    }
}

