/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import edu.wlu.cs.levy.CG.SearchResult;
import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.MyNonFiringWaveListener;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;
import xander.gfws.data.DataPoint;
import xander.gfws.segment.Segmenter;

public abstract class AbstractWaveLogger<T>
implements MyWaveListener,
OpponentWaveListener,
MyNonFiringWaveListener {
    protected boolean offensive;
    protected Segmenter[] segmenters;
    protected RobotProxy robotProxy;
    protected int totalHits;
    protected int totalVisits;
    protected boolean addHitsForNonFiringWaves;

    public AbstractWaveLogger(boolean offensive, Segmenter ... segmenters) {
        this.offensive = offensive;
        this.segmenters = segmenters;
        this.robotProxy = Resources.getRobotProxy();
        if (offensive) {
            Resources.getWaveHistory().addMyWaveListener(this);
            Resources.getWaveHistory().addMyNonFiringWaveListener(this);
        } else {
            Resources.getWaveHistory().addOpponentWaveListener(this);
        }
    }

    protected abstract void addHit(Wave var1, Segmenter[] var2, DataPoint var3);

    protected abstract void addVisit(Wave var1, Segmenter[] var2, DataPoint var3);

    protected abstract SearchResult<DataPoint> getHitData(Wave var1, Segmenter[] var2, T var3);

    protected abstract SearchResult<DataPoint> getVisitData(Wave var1, Segmenter[] var2, T var3);

    public SearchResult<DataPoint> getHitData(Wave wave, T parms) {
        return this.getHitData(wave, this.segmenters, parms);
    }

    public SearchResult<DataPoint> getVisitData(Wave wave, T parms) {
        return this.getVisitData(wave, this.segmenters, parms);
    }

    public Segmenter[] getSegmenters() {
        return this.segmenters;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public int getTotalVisits() {
        return this.totalVisits;
    }

    public boolean isAddHitsForNonFiringWaves() {
        return this.addHitsForNonFiringWaves;
    }

    public void setAddHitsForNonFiringWaves(boolean addHitsForNonFiringWaves) {
        this.addHitsForNonFiringWaves = addHitsForNonFiringWaves;
    }

    private void process(Wave bulletWave, double defenderX, double defenderY) {
        double defenderOriginalHeadingFromOrigin = bulletWave.getInitialDefenderBearing();
        double defenderCurrentHeadingFromOrigin = RCMath.getRobocodeAngle(bulletWave.getOriginX(), bulletWave.getOriginY(), defenderX, defenderY);
        double distance = RCMath.getDistanceBetweenPoints(bulletWave.getOriginX(), bulletWave.getOriginY(), defenderX, defenderY);
        double angle = RCMath.getTurnAngle(defenderOriginalHeadingFromOrigin, defenderCurrentHeadingFromOrigin);
        DataPoint dataPoint = new DataPoint(angle, distance, bulletWave.getBulletVelocity(), bulletWave.getSurfDirection(), Resources.getCumulativeTime(), Resources.getTime());
        this.addHit(bulletWave, this.segmenters, dataPoint);
        ++this.totalHits;
    }

    private void processVisit(Wave wave, double defenderX, double defenderY) {
        double defenderOriginalHeadingFromOrigin = wave.getInitialDefenderBearing();
        double defenderCurrentHeadingFromOrigin = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), defenderX, defenderY);
        double angle = RCMath.getTurnAngle(defenderOriginalHeadingFromOrigin, defenderCurrentHeadingFromOrigin);
        double distance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), defenderX, defenderY);
        DataPoint dataPoint = new DataPoint(angle, distance, wave.getBulletVelocity(), wave.getSurfDirection(), Resources.getCumulativeTime(), Resources.getTime());
        this.addVisit(wave, this.segmenters, dataPoint);
        ++this.totalVisits;
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
        if (!this.offensive) {
            double hitAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), oppBullet.getX(), oppBullet.getY());
            double hitDistance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), this.robotProxy.getX(), this.robotProxy.getY());
            Point2D.Double hitLocation = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), hitDistance, hitAngle);
            this.process(wave, hitLocation.x, hitLocation.y);
        }
    }

    @Override
    public void oppWaveHit(Wave wave) {
        if (!this.offensive) {
            this.processVisit(wave, this.robotProxy.getX(), this.robotProxy.getY());
        }
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
        if (!this.offensive) {
            this.process(wave, this.robotProxy.getX(), this.robotProxy.getY());
        }
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
        if (this.offensive) {
            this.process(wave, opponentSnapshot.getX(), opponentSnapshot.getY());
        }
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }

    @Override
    public void myNonFiringWaveCreated(Wave wave) {
    }

    @Override
    public void myNonFiringWaveHit(Wave wave, Snapshot opponentSnapshot) {
        if (this.offensive && this.addHitsForNonFiringWaves) {
            this.process(wave, opponentSnapshot.getX(), opponentSnapshot.getY());
        }
    }

    @Override
    public void myNonFiringWavePassing(Wave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myNonFiringWavePassed(Wave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myNonFiringWaveDestroyed(Wave wave) {
    }
}

