/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.EscapeEnvelope;

import java.util.ArrayList;
import rdt.Wraith.EscapeEnvelope.IEscapeEnvelopeRecorder;
import rdt.Wraith.EscapeEnvelope.PendingEntry;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundEndedEventHandler;
import robocode.RoundEndedEvent;

public class PendingQueue
implements IRoundEndedEventHandler {
    private static final int MAX_PENDING_ENTRIES = 200;
    private ArrayList<PendingEntry> _freePendingEntries = new ArrayList(200);
    private ArrayList<PendingEntry> _queue = new ArrayList(200);

    public PendingQueue(IRobot robot) {
        for (int index = 0; index < 200; ++index) {
            this._freePendingEntries.add(new PendingEntry());
        }
        robot.RegisterForEventHandling(this);
    }

    public void QueueEntry(long currentTick, long duration) {
        PendingEntry entry = this._freePendingEntries.remove(this._freePendingEntries.size() - 1);
        entry.OriginalTick = currentTick;
        entry.Duration = duration;
        entry.CompletedTick = currentTick + duration;
        this._queue.add(entry);
    }

    public void CheckQueue(long currentTick, IEscapeEnvelopeRecorder recorder) {
        for (int index = this._queue.size() - 1; index >= 0; --index) {
            PendingEntry entry = this._queue.get(index);
            if (entry.CompletedTick > currentTick) continue;
            recorder.RecordNewPayload(entry);
            this._queue.remove(index);
            this._freePendingEntries.add(entry);
        }
    }

    @Override
    public void OnRoundEndedEvent(RoundEndedEvent eventData) {
        this.ClearQueue();
    }

    private void ClearQueue() {
        this._freePendingEntries.addAll(this._queue);
        this._queue.clear();
    }
}

