/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.IRobot;
import rdt.Wraith.ISubsystemMode;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import robocode.util.Utils;

public class AimAtTargetMode
implements ISubsystemMode {
    private final IRobot _robot;
    private final ITargeting _targeting;

    public AimAtTargetMode(IRobot robot, ITargeting targeting) {
        this._robot = robot;
        this._targeting = targeting;
    }

    @Override
    public void UpdateHighestPriority() {
        if (!this._targeting.HasValidTarget()) {
            return;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return;
        }
        long safePredictedTick = target.GetSafePredictedTick(this._robot.getTime() + 1L);
        RobotSnapshot targetSnapshot = target.RobotSnapshots.Read(safePredictedTick);
        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetSnapshot.AbsoluteAngleFromOpponent - this._robot.getGunHeadingRadians())));
    }

    @Override
    public float GetPriority() {
        if (!this._targeting.HasValidTarget()) {
            return 0.0f;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return 0.0f;
        }
        return 0.1f;
    }

    @Override
    public void Update() {
    }
}

