/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Waves;

import java.util.ArrayList;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.MEA.IMEACalculator;
import rdt.Wraith.MEA.MEA;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.RuleUtils;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;

public abstract class WaveManagerBase
implements IWaveManager,
IRoundStartedEventHandler {
    private double _ignoreHitDistanceSq;
    private ArrayList<WaveData> _activeWaves;
    private ArrayList<WaveData> _inactiveWaves;
    protected ArrayList<IWaveEventHandler> _eventHandlers = new ArrayList();
    protected IRobot _robot;
    protected MEA _mea = new MEA();
    protected IMEACalculator _meaCalculator;

    protected WaveManagerBase(IRobot robot, int maxWaves, IMEACalculator meaCalculator) {
        this._robot = robot;
        this._robot.RegisterForEventHandling(this);
        double slowestBullet = RuleUtils.GetBulletVelocity(3.0);
        double largestDistance = Math.sqrt(this._robot.getBattleFieldWidth() * this._robot.getBattleFieldWidth() + this._robot.getBattleFieldHeight() * this._robot.getBattleFieldWidth());
        int maxTicks = (int)Math.ceil(largestDistance / slowestBullet);
        this._activeWaves = new ArrayList(maxTicks);
        this._inactiveWaves = new ArrayList(maxTicks);
        for (int index = 0; index < maxWaves; ++index) {
            this._inactiveWaves.add(new WaveData(maxTicks));
        }
        this._ignoreHitDistanceSq = this._robot.getBotSizeMax() * 1.1 + this._robot.getBotSizeMax() * 1.1;
        this._meaCalculator = meaCalculator;
    }

    @Override
    public ArrayList<WaveData> GetActiveWaves() {
        return this._activeWaves;
    }

    @Override
    public void Update() {
        int activeWaveCount = this._activeWaves.size();
        for (int waveIndex = activeWaveCount - 1; waveIndex >= 0; --waveIndex) {
            WaveData activeWave = this._activeWaves.get(waveIndex);
            if (activeWave.TickWaveIsOutsideBattlefield > this._robot.getTime()) continue;
            this._activeWaves.remove(waveIndex);
            this._inactiveWaves.add(activeWave);
        }
    }

    @Override
    public void FireWave(double originX, double originY, WaveData.eWaveType waveType, double bulletFirepower, long waveActivationTick, Target targetThatFired, RobotSnapshot targetSnapshot) {
        WaveData wave = this._inactiveWaves.remove(this._inactiveWaves.size() - 1);
        double waveVelocity = RuleUtils.GetBulletVelocity(bulletFirepower);
        double distanceToFurthestWall = RuleUtils.GetDistanceToFurthestCorner(originX, originY);
        long ticksToOutsideOfBattlefield = (long)Math.ceil(distanceToFurthestWall / waveVelocity);
        long ticksToTarget = (long)Math.ceil(targetSnapshot.DistanceToItsTarget / waveVelocity);
        this._meaCalculator.CalculateMEA(originX, originY, targetSnapshot, ticksToTarget, waveVelocity, this._mea);
        assert (!(targetSnapshot.RotationDirectionToTarget >= 0.0) ? this._mea.ForwardRelative <= 0.0 : this._mea.ForwardRelative >= 0.0);
        assert (!(targetSnapshot.RotationDirectionToTarget >= 0.0) ? this._mea.RearRelative >= 0.0 : this._mea.RearRelative <= 0.0);
        wave.ActivationTick = waveActivationTick;
        wave.TickWaveIsOutsideBattlefield = waveActivationTick + ticksToOutsideOfBattlefield;
        wave.WaveType = waveType;
        wave.OriginX = originX;
        wave.OriginY = originY;
        wave.Firepower = bulletFirepower;
        wave.Velocity = waveVelocity;
        wave.MEA.ForwardRelative = this._mea.ForwardRelative;
        wave.MEA.RearRelative = this._mea.RearRelative;
        wave.TargetThatFired = targetThatFired;
        wave.PassedTargets.clear();
        double distance = 0.0;
        int tick = 0;
        while ((long)tick < ticksToOutsideOfBattlefield) {
            wave.DistanceAtTick[tick] = distance;
            distance += waveVelocity;
            ++tick;
        }
        this._activeWaves.add(wave);
        for (int index = 0; index < this._eventHandlers.size(); ++index) {
            this._eventHandlers.get(index).OnWaveGeneratedEvent();
        }
    }

    @Override
    public void OnRoundStartedEvent() {
        int activeWaveCount = this._activeWaves.size();
        for (int waveIndex = activeWaveCount - 1; waveIndex >= 0; --waveIndex) {
            WaveData activeWave = this._activeWaves.remove(waveIndex);
            this._inactiveWaves.add(activeWave);
        }
    }

    @Override
    public void RegisterWaveEventHandler(IWaveEventHandler waveEventHandler) {
        this._eventHandlers.add(waveEventHandler);
    }

    @Override
    public WaveData GetClosestActiveWave(double x, double y) {
        double closestDistanceSq = Double.MAX_VALUE;
        WaveData closestWave = null;
        int activeWaves = this._activeWaves.size();
        long currentTick = this._robot.getTime();
        for (int index = 0; index < activeWaves; ++index) {
            WaveData wave;
            double dX = x - wave.OriginX;
            double dY = y - wave.OriginY;
            double distanceToWavesSourceSq = dX * dX + dY * dY;
            wave = this._activeWaves.get(index);
            double waveDistance = wave.GetDistanceForTick(currentTick);
            double waveDistanceSq = waveDistance * waveDistance;
            double distanceToWaveSq = Math.abs(distanceToWavesSourceSq - waveDistanceSq);
            if (!(distanceToWaveSq < closestDistanceSq) || !(distanceToWaveSq <= this._ignoreHitDistanceSq)) continue;
            closestWave = wave;
            closestDistanceSq = distanceToWaveSq;
        }
        return closestWave;
    }

    protected void RemoveActiveWave(WaveData wave) {
        this._activeWaves.remove(wave);
        this._inactiveWaves.add(wave);
    }
}

