/*
 * Decompiled with CFR 0.152.
 */
package ds.targeting;

import ds.DateTime;
import ds.Math2;
import ds.PositionLog;
import ds.targeting.IVirtualBot;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class VirtualBot
implements IVirtualBot {
    private static final double ROBOT_SIZE = 35.0;
    private String m_name;
    private double m_headingRadians;
    private double m_bearingRadians;
    private double m_absoluteBearingRadians;
    private Point2D.Double m_position;
    private double m_velocity;
    private double m_relativeHeading;
    private double m_previousHeadingRadians;
    private double m_distance;
    private double m_timeSinceLastAccel;
    private double m_timeSinceLastDeccel;
    private double m_timeSinceLastVelocityInversion;
    private double m_acceleration;
    private double m_energy;
    private int m_timeSinceLastShot;
    private double m_lastShotPower;
    private int m_timeSinceLastDamageTaken;
    private double m_lateralVelocity;
    private double m_lastNonNullLateralVelocity;
    private double m_previousLateralVelocity;
    private double m_previousNonNullVelocity;
    private DateTime m_dateTime;
    private PositionLog m_positionLog;

    public VirtualBot(String name) {
        this.m_name = name;
        this.m_previousHeadingRadians = 0.0;
        this.m_positionLog = new PositionLog(30);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void updateFromScan(AdvancedRobot referent, ScannedRobotEvent event) {
        this.m_dateTime = new DateTime(referent.getRoundNum(), referent.getTime());
        double previousVelocity = this.m_velocity;
        if (this.m_velocity != 0.0) {
            this.m_previousNonNullVelocity = this.m_velocity;
        }
        this.m_previousLateralVelocity = this.m_lateralVelocity;
        if (this.m_lateralVelocity != 0.0) {
            this.m_lastNonNullLateralVelocity = this.m_lateralVelocity;
        }
        this.m_name = event.getName();
        this.m_previousHeadingRadians = this.m_headingRadians;
        this.m_headingRadians = event.getHeadingRadians();
        this.m_bearingRadians = event.getBearingRadians();
        this.m_absoluteBearingRadians = this.getBearingRadians() + referent.getHeadingRadians();
        this.m_position = Math2.getRelativePosition(this.getAbsoluteBearingRadians(), event.getDistance());
        this.m_position.setLocation(this.m_position.getX() + referent.getX(), this.m_position.getY() + referent.getY());
        this.m_velocity = event.getVelocity();
        this.m_acceleration = this.m_velocity - previousVelocity;
        this.m_lateralVelocity = this.m_velocity * Math.sin(this.m_headingRadians - this.m_absoluteBearingRadians);
        this.m_relativeHeading = Utils.normalRelativeAngle((double)(this.m_headingRadians - this.m_absoluteBearingRadians));
        this.m_distance = this.m_position.distance(referent.getX(), referent.getY());
        this.m_timeSinceLastAccel = previousVelocity < this.m_velocity ? 0.0 : (this.m_timeSinceLastAccel += 1.0);
        this.m_timeSinceLastDeccel = previousVelocity > this.m_velocity ? 0.0 : (this.m_timeSinceLastDeccel += 1.0);
        this.m_timeSinceLastVelocityInversion = this.m_previousNonNullVelocity < 0.0 && this.m_velocity > 0.0 || this.m_previousNonNullVelocity > 0.0 && this.m_velocity < 0.0 ? 0.0 : (this.m_timeSinceLastVelocityInversion += 1.0);
        ++this.m_timeSinceLastShot;
        ++this.m_timeSinceLastDamageTaken;
        double energyDrop = this.m_energy - event.getEnergy();
        if (energyDrop < 3.01 && energyDrop > 0.0042) {
            this.m_timeSinceLastShot = 0;
            this.m_lastShotPower = energyDrop;
        } else if (energyDrop > 0.0) {
            this.m_timeSinceLastDamageTaken = 0;
        }
        this.m_energy = event.getEnergy();
        this.m_positionLog.add(this.m_position);
    }

    @Override
    public double getHeadingRadians() {
        return this.m_headingRadians;
    }

    @Override
    public double getBearingRadians() {
        return this.m_bearingRadians;
    }

    @Override
    public double getAbsoluteBearingRadians() {
        return this.m_absoluteBearingRadians;
    }

    @Override
    public double getX() {
        return this.m_position.getX();
    }

    @Override
    public double getY() {
        return this.m_position.getY();
    }

    @Override
    public Point2D.Double getPosition() {
        return this.m_position;
    }

    @Override
    public Point2D getUpperRightCorner() {
        return new Point2D.Double(this.getX() + 17.5, this.getY() + 17.5);
    }

    @Override
    public Point2D getBottomLeftCorner() {
        return new Point2D.Double(this.getX() - 17.5, this.getY() - 17.5);
    }

    @Override
    public double getSize() {
        return 35.0;
    }

    @Override
    public double getVelocity() {
        return this.m_velocity;
    }

    @Override
    public double getRelativeHeading() {
        return this.m_relativeHeading;
    }

    @Override
    public double getTurnRate() {
        return Utils.normalRelativeAngle((double)(this.m_headingRadians - this.m_previousHeadingRadians));
    }

    @Override
    public double getDistance() {
        return this.m_distance;
    }

    @Override
    public double getTimeSinceLastAccel() {
        return this.m_timeSinceLastAccel;
    }

    @Override
    public double getTimeSinceLastDeccel() {
        return this.m_timeSinceLastDeccel;
    }

    @Override
    public double getTimeSinceLastVelocityInversion() {
        return this.m_timeSinceLastVelocityInversion;
    }

    @Override
    public double getTimeSinceLastVelocityChange() {
        return Math.min(this.m_timeSinceLastAccel, this.m_timeSinceLastDeccel);
    }

    @Override
    public double getAcceleration() {
        return this.m_acceleration;
    }

    public Object clone() throws CloneNotSupportedException {
        VirtualBot bot = null;
        try {
            bot = (VirtualBot)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
        }
        bot.m_position = (Point2D.Double)this.m_position.clone();
        return bot;
    }

    @Override
    public double getEnergy() {
        return this.m_energy;
    }

    @Override
    public int getTimeSinceLastShot() {
        return this.m_timeSinceLastShot;
    }

    @Override
    public double getLastShotPower() {
        return this.m_lastShotPower;
    }

    @Override
    public int getTimeSinceLastDamageTaken() {
        return this.m_timeSinceLastDamageTaken;
    }

    @Override
    public void update() {
    }

    @Override
    public double getLateralVelocity() {
        return this.m_lateralVelocity;
    }

    @Override
    public double getLastNonNullLateralVelocity() {
        return this.m_lastNonNullLateralVelocity;
    }

    @Override
    public double getLateralDirection() {
        return this.getLastNonNullLateralVelocity() >= 0.0 ? 1 : -1;
    }

    @Override
    public double getLateralAccell() {
        return this.m_lateralVelocity - this.m_previousLateralVelocity;
    }

    @Override
    public DateTime getDateTime() {
        return this.m_dateTime;
    }

    @Override
    public PositionLog getPositionLog() {
        return this.m_positionLog;
    }
}

