/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import muf.utils.IndexMaker;

public class LinearIndexMaker
implements IndexMaker {
    protected double minValue;
    protected double maxValue;
    protected int maxIndex;
    protected double intervalSize;

    public LinearIndexMaker(double d, double d2, int n) {
        this.minValue = d;
        this.maxValue = d2;
        this.maxIndex = n;
        this.intervalSize = (d2 - d) / (double)(n + 1);
    }

    public int getIndex(double d) {
        int n = (int)Math.floor((d - this.minValue) / this.intervalSize);
        if (n < 0) {
            n = 0;
        }
        if (n > this.maxIndex) {
            n = this.maxIndex;
        }
        return n;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public double getValueByIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.maxIndex) {
            n = this.maxIndex;
        }
        return this.minValue + ((double)n + 0.5) * this.intervalSize;
    }
}

