/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.robot;

import java.awt.geom.Point2D;
import java.io.Serializable;
import kid.data.Printable;
import kid.info.RobotInfo;
import kid.movement.robot.RobotMovement;
import kid.robot.RobotData;
import kid.virtual.VirtualBullet;
import robocode.Event;
import robocode.Robot;

public abstract class Movement
implements Cloneable,
Serializable,
Printable {
    private static final long serialVersionUID = -2922544471044145148L;
    protected Robot robot;
    protected RobotInfo info;
    protected RobotMovement movement;

    protected Movement(Robot myRobot) {
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        this.movement = new RobotMovement(myRobot);
        this.info = new RobotInfo(myRobot);
    }

    public final void move(RobotData[] robots) {
        this.move(robots, new VirtualBullet[0]);
    }

    public abstract void move(RobotData[] var1, VirtualBullet[] var2);

    public final Point2D[] getMove(RobotData[] robots, long time) {
        return this.getMove(robots, new VirtualBullet[0], time);
    }

    public abstract Point2D[] getMove(RobotData[] var1, VirtualBullet[] var2, long var3);

    public abstract void inEvent(Event var1);

    public abstract String getName();

    public abstract String getType();

    protected void finalize() throws Throwable {
        this.robot = null;
        this.info = null;
        super.finalize();
    }
}

