/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.guns.OneVsOne;

import gre.svman4.guns.CalculateBulletPower;
import gre.svman4.guns.GunInformation;
import gre.svman4.guns.OneVsOne.OneVsOneGun;
import gre.svman4.useful.RobotState;
import robocode.Rules;

public class LinearTargetingGun
extends OneVsOneGun {
    public LinearTargetingGun(RobotState me) {
        super(me);
    }

    @Override
    public GunInformation getFiringInformation() {
        GunInformation info = new GunInformation();
        double bulletPower = CalculateBulletPower.calculate(this._mineRobot, this._target);
        double directAngle = this._mineRobot.getAngleTo(this._target);
        info.bulletPower = bulletPower;
        info.shootingAngle = directAngle - this._target.velocity * Math.sin(directAngle - this._target.heading) / Rules.getBulletSpeed((double)bulletPower);
        return info;
    }

    public double calculateBulletPower() {
        double distance = 0.0;
        double answer = 0.0;
        distance = this._target.distance(this._mineRobot);
        answer = Math.min(2.0 * (300.0 / distance), this._target.energy / 3.0);
        return answer;
    }

    @Override
    public String getName() {
        return "LinearTargetingGun";
    }
}

