/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.IBulletObject;
import morbid.IEnemyBulletManager;
import morbid.IObject;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.IStateSensor;
import morbid.Utils;

interface IPotentialManager
extends IStateSensor {
    public static final double SCALE = 1000000.0;

    public IForcePoint addForcePoint(IForcePoint var1);

    public IForcePoint removeForcePoint(String var1);

    public IForcePoint getForcePoint(String var1);

    public IForcePoint[] getActiveForcePoints();

    public double[] getTotalActiveForce(double var1, double var3);

    public double[] getTotalActiveForce(double[] var1);

    public static class EnemyBulletForceLine
    extends IObject.DNamedMovingObject
    implements IForcePoint {
        private final IRobotController m_controller;
        private final double m_scale;
        private final double m_size;

        public boolean isActive() {
            IEnemyBulletManager enemyBulletManager = this.m_controller.getEnemyBulletManager();
            return enemyBulletManager.isActive(this.getID());
        }

        public void getForce(double[] out, double x, double y) {
            double phi_V = this.getHeadingRadians();
            double phi_xy = Utils.relativeHeading(this.getXY(), x, y);
            double phi_delta = Utils.deltaPhi(phi_xy, phi_V);
            double phi_f = phi_delta > 0.0 ? phi_V + 1.5707963267948966 : phi_V - 1.5707963267948966;
            double r = Utils.relativeDistance(this.getXY(), x, y) * Math.abs(Math.sin(phi_delta)) / this.m_size - 1.0;
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r));
            out[0] = f * Math.sin(phi_f);
            out[1] = f * Math.cos(phi_f);
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        EnemyBulletForceLine(IRobotController controller, double scale, double size, IBulletObject.IBullet bullet) {
            super(bullet);
            this.m_controller = controller;
            this.m_scale = scale;
            this.m_size = size;
        }
    }

    public static class EnemyBulletForcePoint
    extends IObject.DNamedMovingObject
    implements IForcePoint {
        private final IRobotController m_controller;
        private final double m_scale;
        private final double m_size;

        public boolean isActive() {
            IEnemyBulletManager enemyBulletManager = this.m_controller.getEnemyBulletManager();
            return enemyBulletManager.isActive(this.getID());
        }

        public void getForce(double[] out, double x, double y) {
            double r = Utils.relativeDistance(this.getXY(), x, y) / this.m_size - 1.0;
            double phi = Utils.relativeHeading(this.getXY(), x, y);
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r));
            out[0] = f * Math.sin(phi);
            out[1] = f * Math.cos(phi);
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        EnemyBulletForcePoint(IRobotController controller, double scale, double size, IBulletObject.IBullet bullet) {
            super(bullet);
            this.m_controller = controller;
            this.m_scale = scale;
            this.m_size = size;
        }
    }

    public static class EnemyForcePoint
    extends IObject.DNamedMovingObject
    implements IForcePoint {
        private final IRobotController m_controller;
        private final double m_scale;
        private final double m_size;

        public boolean isActive() {
            IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
            return robotPositionManager.isKnownAlive(this.getID());
        }

        public void getForce(double[] out, double x, double y) {
            double r = Utils.relativeDistance(this.getXY(), x, y) / this.m_size - 1.0;
            double phi = Utils.relativeHeading(this.getXY(), x, y);
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r));
            out[0] = f * Math.sin(phi);
            out[1] = f * Math.cos(phi);
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        EnemyForcePoint(IRobotController controller, double scale, double size, IRobotPositionManager.IUpdatedRobot enemy) {
            super(enemy);
            this.m_controller = controller;
            this.m_scale = scale;
            this.m_size = size;
        }
    }

    public static class TimedForcePoint
    extends PermanentForcePoint
    implements IForcePoint {
        private final IRobotController m_controller;
        private final long m_deathtime;

        public boolean isActive() {
            return this.m_controller.getRobot().getTime() < this.m_deathtime;
        }

        TimedForcePoint(IRobotController controller, double scale, double size, double x, double y, long lifetime) {
            super(Utils.getGID("TFP"), scale, size, x, y);
            this.m_controller = controller;
            this.m_deathtime = controller.getRobot().getTime() + lifetime;
        }
    }

    public static class TimedForceLine
    extends PermanentForceLine2 {
        private final IRobotController m_controller;
        private final long m_deathtime;

        public boolean isActive() {
            return this.m_controller.getRobot().getTime() < this.m_deathtime;
        }

        TimedForceLine(IRobotController controller, double scale, double size, double x, double y, double direction, long lifetime) {
            super(Utils.getGID("TL"), scale, size, x, y, direction);
            this.m_controller = controller;
            this.m_deathtime = controller.getRobot().getTime() + lifetime;
        }
    }

    public static class PermanentForceLine3
    extends IObject.NamedXYObject
    implements IForcePoint {
        private final double m_scale;
        private final double m_size;
        private final double m_direction;
        private final double m_cos_direction;
        private final double m_sin_direction;

        public double getHeadingRadians() {
            return 0.0;
        }

        public double getVelocity() {
            return 0.0;
        }

        public boolean isActive() {
            return true;
        }

        public void getForce(double[] out, double x, double y) {
            double r = Utils.relativeDistance(this.getXY(), x, y) * Math.cos(Utils.relativeHeading(this.getXY(), x, y) - this.m_direction) / this.m_size - 1.0;
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r * r));
            out[0] = f * this.m_sin_direction;
            out[1] = f * this.m_cos_direction;
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        PermanentForceLine3(String ID, double scale, double size, double x, double y, double direction) {
            super(ID, x, y);
            this.m_scale = scale;
            this.m_size = size;
            this.m_direction = direction;
            this.m_cos_direction = Math.cos(direction);
            this.m_sin_direction = Math.sin(direction);
        }

        PermanentForceLine3(double scale, double size, double x, double y, double direction) {
            this(Utils.getGID("FL"), scale, size, x, y, direction);
        }
    }

    public static class PermanentForceLine2
    extends IObject.NamedXYObject
    implements IForcePoint {
        private final double m_scale;
        private final double m_size;
        private final double m_direction;
        private final double m_cos_direction;
        private final double m_sin_direction;

        public double getHeadingRadians() {
            return 0.0;
        }

        public double getVelocity() {
            return 0.0;
        }

        public boolean isActive() {
            return true;
        }

        public void getForce(double[] out, double x, double y) {
            double r = Utils.relativeDistance(this.getXY(), x, y) * Math.cos(Utils.relativeHeading(this.getXY(), x, y) - this.m_direction) / this.m_size - 1.0;
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r));
            out[0] = f * this.m_sin_direction;
            out[1] = f * this.m_cos_direction;
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        PermanentForceLine2(String ID, double scale, double size, double x, double y, double direction) {
            super(ID, x, y);
            this.m_scale = scale;
            this.m_size = size;
            this.m_direction = direction;
            this.m_cos_direction = Math.cos(direction);
            this.m_sin_direction = Math.sin(direction);
        }

        PermanentForceLine2(double scale, double size, double x, double y, double direction) {
            this(Utils.getGID("FL"), scale, size, x, y, direction);
        }
    }

    public static class PermanentForcePoint
    extends IObject.NamedXYObject
    implements IForcePoint {
        private final double m_scale;
        private final double m_size;

        public double getHeadingRadians() {
            return 0.0;
        }

        public double getVelocity() {
            return 0.0;
        }

        public boolean isActive() {
            return true;
        }

        public void getForce(double[] out, double x, double y) {
            double phi = Utils.relativeHeading(this.getXY(), x, y);
            double r = Utils.relativeDistance(this.getXY(), x, y) / this.m_size - 1.0;
            double f = 1000000.0 * (r <= 0.0 ? this.m_scale : this.m_scale / (1.0 + r * r));
            out[0] = f * Math.sin(phi);
            out[1] = f * Math.cos(phi);
        }

        public void getForce(double[] out, double[] xy) {
            this.getForce(out, xy[0], xy[1]);
        }

        protected PermanentForcePoint(String ID, double scale, double size, double x, double y) {
            super(ID, x, y);
            this.m_scale = scale;
            this.m_size = size;
        }

        PermanentForcePoint(double scale, double size, double x, double y) {
            this(Utils.getGID("WP"), scale, size, x, y);
        }
    }

    public static interface IForcePoint
    extends IObject.INamedMovingObject,
    IObject.ITransientObject {
        public void getForce(double[] var1, double var2, double var4);

        public void getForce(double[] var1, double[] var2);
    }
}

