/*
 * Decompiled with CFR 0.152.
 */
package Targeting;

import Targeting.TargetingStuff;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

public class TargetingWave
extends Condition {
    public static Point2D targetLocation;
    public double bulletPower;
    public Point2D gunLocation;
    public double bearing;
    public double lateralDirection;
    public static final double MAX_DISTANCE = 900.0;
    public static final int DISTANCE_INDEXES = 5;
    public static final int VELOCITY_INDEXES = 5;
    public static final int BINS = 25;
    public static final int MIDDLE_BIN = 12;
    public static final double MAX_ESCAPE_ANGLE = 0.7;
    public static final double BIN_WIDTH = 0.05833333333333333;
    public static int[][][][] statBuffers;
    public int[] buffer;
    public AdvancedRobot robot;
    public double distanceTraveled;

    static {
        statBuffers = new int[5][5][5][25];
    }

    public TargetingWave(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public boolean test() {
        this.advance();
        if (this.hasArrived()) {
            int n = this.currentBin();
            this.buffer[n] = this.buffer[n] + 1;
            this.robot.removeCustomEvent((Condition)this);
        }
        return false;
    }

    public double mostVisitedBearingOffset() {
        return this.lateralDirection * 0.05833333333333333 * (double)(this.mostVisitedBin() - 12);
    }

    public void setSegmentations(double distance, double velocity, double lastVelocity) {
        int distanceIndex = (int)(distance / 180.0);
        int velocityIndex = (int)Math.abs(velocity / 2.0);
        int lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
        this.buffer = statBuffers[distanceIndex][velocityIndex][lastVelocityIndex];
    }

    public void advance() {
        this.distanceTraveled += TargetingStuff.bulletVelocity(this.bulletPower);
    }

    public boolean hasArrived() {
        return this.distanceTraveled > this.gunLocation.distance(targetLocation) - 18.0;
    }

    public int currentBin() {
        int bin = (int)Math.round(Utils.normalRelativeAngle((double)(TargetingStuff.absoluteBearing(this.gunLocation, targetLocation) - this.bearing)) / (this.lateralDirection * 0.05833333333333333) + 12.0);
        return TargetingStuff.minMax(bin, 0, 24);
    }

    public int mostVisitedBin() {
        int mostVisited = 12;
        int i = 0;
        while (i < 25) {
            if (this.buffer[i] > this.buffer[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }
}

