/*
 * Decompiled with CFR 0.152.
 */
package ghent;

import ghent.common.Direction;
import ghent.common.Target;
import ghent.modules.EventRobot;
import ghent.modules.artillery.Ballistics;
import ghent.modules.artillery.Gunner;
import ghent.modules.decision.TargetChooser;
import ghent.modules.detection.Radar;
import ghent.modules.navigation.Navigator;
import java.awt.Color;
import robocode.HitRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.util.Utils;

public class ArthurPanzergon
extends EventRobot {
    private Radar _radar = new Radar(this);
    private Gunner _gunner = null;
    private Navigator _navigator = null;
    private TargetChooser _targetChooser = null;

    public ArthurPanzergon() {
        this.addEventsListener(this._radar);
        this._gunner = new Gunner(this);
        this.addEventsListener(this._gunner);
        this._navigator = new Navigator(this);
        this.addEventsListener(this._navigator);
        this._targetChooser = new TargetChooser(this, this._radar.getTargets());
        this.addEventsListener(this._targetChooser);
    }

    public void run() {
        this.setup();
        Ballistics ballistics = null;
        Target target = null;
        this._navigator.moveTo(this.getX() < this.getBattleFieldWidth() / 2.0 ? 90.0 : 270.0, Double.POSITIVE_INFINITY);
        while (true) {
            if (this.getGunTurnRemaining() == 0.0) {
                if (ballistics != null && Math.abs(ballistics.getRotation()) <= 20.0) {
                    if (this._gunner.canFire()) {
                        this._gunner.setFire(ballistics);
                        if (target != null) {
                            this._gunner.fireVirtualBullets(target);
                            this._targetChooser.setLastTarget(target);
                        }
                        target = null;
                        this._radar.unlock();
                    }
                    ballistics = null;
                }
                if (target == null) {
                    target = this._targetChooser.chooseTarget();
                    this._radar.setLock(target);
                }
                if (target != null) {
                    if ((ballistics == null || Math.abs(ballistics.getRotation()) > 20.0) && (ballistics = this._gunner.getBallistics(target)) != null && ballistics.getPower() > 0.0) {
                        this._gunner.prepareFire(ballistics);
                    }
                    if (this._targetChooser.getMissed() >= 5) {
                        this._navigator.moveTo(target.getLocation());
                    }
                }
            }
            this._radar.scan();
            this.execute();
        }
    }

    private void setup() {
        this.setColor();
        this._radar.init();
        this._gunner.init();
        this._navigator.init();
        this._targetChooser.init();
    }

    protected void setColor() {
        this.setBodyColor(Color.BLUE);
        this.setGunColor(Color.BLUE);
        this.setRadarColor(Color.YELLOW);
        this.setScanColor(Color.BLUE);
        this.setBulletColor(Color.BLUE);
    }

    public void onDetectFire(Target t) {
        if (this.getOthers() <= 1) {
            this._navigator.runAway();
        }
    }

    public void onNearWall(Direction directionWall) {
        if (this.getVelocity() == 0.0) {
            return;
        }
        double heading = this.getHeading();
        if (this.getVelocity() < 0.0) {
            heading = Utils.normalAbsoluteAngleDegrees((double)(heading + 180.0));
        }
        double distBeforeStop = this._navigator.distanceBeforeStop();
        if (directionWall.similarTo(Direction.NORTH) && (heading > 270.0 || heading < 90.0)) {
            if (this.getY() > this.getBattleFieldHeight() - 36.0 - distBeforeStop) {
                this.setStop();
            } else if (this.getTurnRemaining() == 0.0) {
                if (this.getX() < this.getBattleFieldWidth() / 2.0 || heading < 360.0) {
                    this.setTurnRight(90.0);
                } else {
                    this.setTurnLeft(90.0);
                }
            }
        } else if (directionWall.similarTo(Direction.EAST) && heading < 180.0) {
            if (this.getX() > this.getBattleFieldWidth() - 36.0 - distBeforeStop) {
                this.setStop();
            } else if (this.getTurnRemaining() == 0.0) {
                if (this.getY() < this.getBattleFieldHeight() / 2.0 || heading < 90.0) {
                    this.setTurnLeft(90.0);
                } else {
                    this.setTurnRight(90.0);
                }
            }
        } else if (directionWall.similarTo(Direction.SOUTH) && heading < 270.0 && heading > 90.0) {
            if (this.getY() < distBeforeStop + 36.0) {
                this.setStop();
            } else if (this.getTurnRemaining() == 0.0) {
                if (this.getX() < this.getBattleFieldWidth() / 2.0 || heading < 180.0) {
                    this.setTurnLeft(90.0);
                } else {
                    this.setTurnRight(90.0);
                }
            }
        } else if (directionWall.similarTo(Direction.WEST) && heading > 180.0) {
            if (this.getX() < distBeforeStop + 36.0) {
                this.setStop();
            } else if (this.getTurnRemaining() == 0.0) {
                if (this.getY() < this.getBattleFieldHeight() / 2.0 || heading > 270.0) {
                    this.setTurnRight(90.0);
                } else {
                    this.setTurnLeft(90.0);
                }
            }
        }
    }

    public void onHitRobotCustom(HitRobotEvent event) {
        Target t = this._radar.getTargetByName(event.getName());
        this._navigator.ram(t);
    }

    public void onSkippedTurnCustom(SkippedTurnEvent event) {
        this.out.println("SKIP TURN...........");
    }
}

