/*
 * Decompiled with CFR 0.152.
 */
package bzdp;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BoxCar
extends AdvancedRobot {
    boolean goingForward = true;
    double oldEnemyHeading = 0.0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.execute();
        while (true) {
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            this.turnAndGo();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double bulletPower = Math.min(e.getDistance() % 3.0 + 1.0, this.getEnergy());
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        double enemyVelocity = e.getVelocity();
        this.oldEnemyHeading = enemyHeading;
        double deltaTime = 0.0;
        double battleFieldHeight = this.getBattleFieldHeight();
        double battleFieldWidth = this.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(this.getX(), this.getY(), predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)((absoluteBearing - this.getRadarHeadingRadians()) * 1.99)));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.setFire(bulletPower);
        this.turnAndGo();
        this.execute();
    }

    public void onHitWall(HitWallEvent event) {
        this.goingForward = !this.goingForward;
        this.turnAndGo();
        this.execute();
    }

    public void onHitRobot(HitRobotEvent event) {
        this.goingForward = !(event.getBearing() > -90.0) || !(event.getBearing() <= 90.0);
        this.turnAndGo();
        this.execute();
    }

    public void turnAndGo() {
        double height = this.getBattleFieldHeight();
        double width = this.getBattleFieldWidth();
        double direction = (this.getHeading() + 45.0) % 360.0;
        if (!this.goingForward) {
            direction = (direction + 180.0) % 360.0;
        }
        short wall = (short)(direction / 90.0);
        boolean turn = false;
        switch (wall) {
            case 0: {
                turn = height - this.getY() < 200.0;
                break;
            }
            case 1: {
                turn = width - this.getX() < 200.0;
                break;
            }
            case 2: {
                turn = this.getY() < 200.0;
                break;
            }
            case 3: {
                boolean bl = turn = this.getX() < 200.0;
            }
        }
        if (turn) {
            if ((short)direction / 45 % 2 == 0 ^ this.goingForward) {
                this.setTurnRight(65.0);
            } else {
                this.setTurnLeft(65.0);
            }
        }
        if (this.goingForward) {
            this.setAhead(100.0);
        } else {
            this.setBack(100.0);
        }
    }
}

