/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.shield;

import xander.cat.group.rem.REMFactory;
import xander.cat.group.shield.BulletShieldingController;
import xander.cat.group.shield.BulletShieldingGun;
import xander.cat.group.shield.BulletShieldingListener;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.Scenario;
import xander.core.event.RoundBeginListener;
import xander.core.math.RCPhysics;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;

public class BulletShieldingScenario
implements Scenario,
RoundBeginListener,
BulletShieldingListener {
    private static boolean firstFailureHasOccurred = false;
    private BulletShieldingController controller;
    private RobotProxy robotProxy;
    private GunStats gunStats;
    private int activationTime;
    private int requiredLeadTimeForOpponentWaves;
    private double disengageDistance;
    private double reengageDistance;
    private boolean previouslyEngaged = true;
    private SnapshotHistory snapshotHistory;
    private boolean disableOnMiss;
    private long reactivateTime;
    private BulletShieldingGun gun;
    private boolean[] conditions = new boolean[10];
    private String[] conditionDescriptions = new String[]{"Before activation time", "Before reactivation time", "Opponent is X5 classified", "Energy cutoff triggered", "Opponent is not firing check 2", "Opponent too close", "Miss damage per shielding shot too high", "Opponent average bullet power too low", "Bullet shielding ratio out of range", "Miss damage exceeds threshold"};
    private int[] conditionFailCounts = new int[9];
    private boolean requiredDistanceIncreased;
    private boolean x5Checked;
    private boolean isX5;
    private boolean isSeraphimChecked;
    private boolean isSeraphim;
    private boolean energyCutoff;

    public BulletShieldingScenario(BulletShieldingController controller, BulletShieldingGun gun, int activationTime, boolean disableOnMiss) {
        this.controller = controller;
        this.gun = gun;
        this.robotProxy = Resources.getRobotProxy();
        this.activationTime = activationTime;
        this.disableOnMiss = disableOnMiss;
        this.gunStats = Resources.getGunStats();
        this.requiredLeadTimeForOpponentWaves = controller.getRequiredLeadTimeForOpponentWaves();
        this.disengageDistance = 20.0 + (double)(this.requiredLeadTimeForOpponentWaves + 1) * RCPhysics.getBulletVelocity(1.5);
        this.reengageDistance = this.disengageDistance + 200.0;
        this.snapshotHistory = Resources.getSnapshotHistory();
        Resources.getRobotEvents().addRoundBeginListener(this);
        controller.addBulletShieldingListener(this);
    }

    public void setDisableOnX5(boolean disableOnX5) {
        if (disableOnX5) {
            this.x5Checked = false;
        } else {
            this.x5Checked = true;
            this.isX5 = false;
        }
    }

    public int[] getConditionFailCounts() {
        return this.conditionFailCounts;
    }

    public String[] getConditionDescriptions() {
        return this.conditionDescriptions;
    }

    @Override
    public void onRoundBegin() {
        this.energyCutoff = false;
        this.reactivateTime = 0L;
        this.requiredDistanceIncreased = false;
        if (this.robotProxy.getRoundNum() > 0) {
            double avgBulletPower = this.gunStats.getAverageOpponentBulletPower();
            this.disengageDistance = 20.0 + (double)(this.requiredLeadTimeForOpponentWaves + 1) * RCPhysics.getBulletVelocity(avgBulletPower);
            this.reengageDistance = this.disengageDistance + 150.0;
        }
    }

    @Override
    public boolean applies() {
        double requiredDistance;
        Snapshot scannedOpponent = this.snapshotHistory.getLastOpponentScanned();
        if (!this.isSeraphimChecked && scannedOpponent != null) {
            this.isSeraphimChecked = true;
            this.isSeraphim = scannedOpponent.getName().startsWith("Seraphim");
        }
        if (this.isSeraphim) {
            return false;
        }
        if (!this.x5Checked && scannedOpponent != null) {
            this.x5Checked = true;
            this.isX5 = REMFactory.isX5(scannedOpponent.getName());
        }
        long timeSinceOpponentFired = Resources.getTime() - this.gunStats.getLastOpponentFireTime();
        if (scannedOpponent != null && scannedOpponent.getEnergy() <= 8.0 && !this.requiredDistanceIncreased) {
            this.disengageDistance += 40.0;
            this.reengageDistance += 40.0;
            this.requiredDistanceIncreased = true;
        }
        double d = requiredDistance = this.previouslyEngaged ? this.disengageDistance : this.reengageDistance;
        if (this.robotProxy.getEnergy() < 30.0 || this.robotProxy.getEnergy() < 50.0 && this.robotProxy.getRoundNum() > 2) {
            this.energyCutoff = true;
        }
        this.conditions[0] = Resources.getTime() >= (long)this.activationTime;
        this.conditions[1] = Resources.getTime() >= this.reactivateTime;
        this.conditions[2] = !this.isX5;
        this.conditions[3] = !this.energyCutoff;
        this.conditions[4] = Resources.getCumulativeTime() < 200L || timeSinceOpponentFired < 250L || scannedOpponent.getEnergy() < 0.5;
        this.conditions[5] = !this.controller.isOpponentTooClose() && (scannedOpponent == null || scannedOpponent.getDistance() >= requiredDistance);
        this.conditions[6] = this.robotProxy.getRoundNum() < 3 || this.controller.getMissDamagePerShieldingShot() < 0.2 || this.robotProxy.getRoundNum() < 6 && this.controller.getMissDamagePerShieldingShot() < 0.3;
        this.conditions[7] = this.gunStats.getOpponentBulletsFired() < 6 || Resources.getTime() < 70L || this.gunStats.getRollingAverageOpponentBulletPower() > 0.15 || this.robotProxy.getEnergy() - scannedOpponent.getEnergy() > 40.0;
        this.conditions[8] = this.controller.getBulletShieldingMisses() < 5 || this.controller.getBulletShieldingConsecutiveMisses() < 5 && (this.controller.getBulletShieldingRatio() > 0.925 || this.controller.getBulletShieldingRatio() > 0.79 && this.controller.getBulletShieldingShots() < 20);
        this.conditions[9] = this.controller.getMissDamage() <= 300.0;
        int i = 0;
        boolean applies = true;
        i = 0;
        while (i < this.conditions.length) {
            if (!this.conditions[i]) {
                applies = false;
            }
            ++i;
        }
        this.previouslyEngaged = applies;
        if (!applies) {
            if (!firstFailureHasOccurred) {
                firstFailureHasOccurred = true;
                i = 0;
                while (i < this.conditions.length) {
                    if (!this.conditions[i]) {
                        int n = i;
                        this.conditionFailCounts[n] = this.conditionFailCounts[n] + 1;
                    }
                    ++i;
                }
            }
            this.controller.reset();
            this.gun.reset();
        }
        return applies;
    }

    @Override
    public void shieldingShotHit(XBulletWave myWave, Wave opponentWave) {
    }

    @Override
    public void shieldingShotMissed(XBulletWave myWave, Wave opponentWave) {
        if (this.robotProxy.getRoundNum() == 0 && this.disableOnMiss && this.robotProxy.getEnergy() < 98.0) {
            long deactivateDuration = Math.min(12L, opponentWave.getTimeUntilHit(this.robotProxy.getX(), this.robotProxy.getY(), Resources.getTime()));
            this.reactivateTime = Resources.getTime() + deactivateDuration;
        }
    }
}

