/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bandol.util.Queue;
import bndl.BulletList;
import bndl.CoolSpotNavigator;
import bndl.PatternState;
import bndl.Scan;
import java.awt.geom.Point2D;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.RobocodeFileWriter;

public class Enemy {
    AdvancedRobot robot;
    CoolSpotNavigator navigator;
    Queue scans;
    Queue pattern;
    int movementState;
    double damageFrom;
    String name;
    double param1;
    double param2;
    double param3;
    boolean alive;
    BulletList bullets;

    public Enemy(String string, AdvancedRobot advancedRobot, CoolSpotNavigator coolSpotNavigator) {
        this.name = string;
        this.robot = advancedRobot;
        this.navigator = coolSpotNavigator;
        this.scans = new Queue(3);
        this.pattern = new Queue(300);
        this.movementState = 0;
        this.alive = true;
        this.damageFrom = 0.0;
        this.bullets = new BulletList(this);
        this.param3 = 0.0;
        this.param2 = 0.0;
        this.param1 = 0.0;
    }

    public void addScan(Scan scan) {
        double d;
        if (this.scans.size() != 0) {
            double d2 = scan.getHeading() - ((Scan)this.scans.elementAt(0)).getHeading();
            this.pattern.add(new PatternState(d2, scan.getVelocity(), scan.getTime()));
        }
        this.scans.add(scan);
        if (this.scans.size() >= 2 && (d = ((Scan)this.scans.elementAt(1)).getEnergy() - ((Scan)this.scans.elementAt(0)).getEnergy()) > 0.3 && d <= 3.0) {
            this.navigator.addVirtualBullet(this, d);
        }
    }

    public void writeData() {
        try {
            RobocodeFileWriter robocodeFileWriter = new RobocodeFileWriter(this.robot.getDataFile(this.getName()));
            Enumeration enumeration = this.pattern.elements();
            while (enumeration.hasMoreElements()) {
                PatternState patternState = (PatternState)enumeration.nextElement();
                robocodeFileWriter.write(new String(patternState.getHeadingChange() + " " + patternState.getVelocity() + " " + patternState.getTime() + ";"));
            }
            robocodeFileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readData() {
        try {
            int n;
            FileReader fileReader = new FileReader(this.robot.getDataFile(this.getName()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = fileReader.read()) != -1) {
                char c = (char)n;
                if (c == ';') {
                    StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " ");
                    if (stringTokenizer.countTokens() != 3) break;
                    double d = Double.parseDouble(stringTokenizer.nextToken());
                    double d2 = Double.parseDouble(stringTokenizer.nextToken());
                    long l = Long.parseLong(stringTokenizer.nextToken());
                    PatternState patternState = new PatternState(d, d2, l);
                    this.pattern.add(patternState);
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
            fileReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onFire(Bullet bullet) {
        if (bullet != null) {
            this.bullets.add(bullet);
        }
    }

    public void updateBulletList() {
        this.bullets.removeOld();
    }

    public void addDamageFrom(double d) {
        this.damageFrom += d;
    }

    public double getHitRate() {
        return this.bullets.getHitRate();
    }

    public int getRounds() {
        return this.bullets.getRounds();
    }

    public int getHits() {
        return this.bullets.getHits();
    }

    public double getDamageFrom() {
        return this.damageFrom;
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public int findPattern() {
        int n = -1;
        if (this.pattern.size() < 50) {
            return -1;
        }
        double d = 0.1;
        int n2 = 7;
        while (n2 < this.pattern.size() - 7) {
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < 7) {
                PatternState patternState = (PatternState)this.pattern.elementAt(n3);
                PatternState patternState2 = (PatternState)this.pattern.elementAt(n2 + n3);
                double d3 = patternState.getDiff(patternState2);
                d2 += d3;
                ++n3;
            }
            if (d2 < d) {
                d = d2;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public Point2D.Double getPatternPoint(long l, int n) {
        long l2 = 0L;
        int n2 = n;
        Point2D.Double double_ = this.getPosition();
        double d = this.getHeading();
        double d2 = this.getVelocity();
        while (l2 < l && n2 > 0) {
            PatternState patternState = (PatternState)this.pattern.elementAt(n2);
            PatternState patternState2 = (PatternState)this.pattern.elementAt(n2 - 1);
            long l3 = patternState2.getTime() - patternState.getTime();
            l2 += l3;
            double_.x += (double)l3 * d2 * Math.sin(d);
            double_.y += (double)l3 * d2 * Math.cos(d);
            --n2;
            d2 = patternState.getVelocity();
            d += patternState.getHeadingChange();
        }
        return double_;
    }

    public Point2D.Double getEstimatedPosition(long l) {
        int n = this.findPattern();
        if (n != -1) {
            return this.getPatternPoint(l, n);
        }
        return this.navigator.getEstimatedPosition(l, this.scans);
    }

    public double getEnergy() {
        return ((Scan)this.scans.elementAt(0)).getEnergy();
    }

    public double getX() {
        if (this.scans.size() != 0) {
            return ((Scan)this.scans.elementAt(0)).getX();
        }
        return 0.0;
    }

    public double getY() {
        if (this.scans.size() != 0) {
            return ((Scan)this.scans.elementAt(0)).getY();
        }
        return 0.0;
    }

    public double getVelocity() {
        if (this.scans.size() != 0) {
            return ((Scan)this.scans.elementAt(0)).getVelocity();
        }
        return 0.0;
    }

    public double getHeading() {
        if (this.scans.size() != 0) {
            return ((Scan)this.scans.elementAt(0)).getHeading();
        }
        return 0.0;
    }

    public double getDirection(double d, double d2) {
        if (this.scans.size() != 0) {
            double d3 = ((Scan)this.scans.elementAt(0)).getX() - d;
            double d4 = ((Scan)this.scans.elementAt(0)).getY() - d2;
            return Math.atan2(d3, d4);
        }
        return 0.0;
    }

    public double getDistance(double d, double d2) {
        if (this.scans.size() != 0) {
            double d3 = ((Scan)this.scans.elementAt(0)).getX() - d;
            double d4 = ((Scan)this.scans.elementAt(0)).getY() - d2;
            return Math.sqrt(d3 * d3 + d4 * d4);
        }
        return 0.0;
    }

    public long getLastUpdated() {
        return ((Scan)this.scans.get(0)).getTime();
    }

    public void die() {
        this.alive = false;
        this.bullets.adjustForRobotDeath();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isUpdated(long l) {
        return l - this.getLastUpdated() <= 30L;
    }

    public String getName() {
        return this.name;
    }

    public int getMovementState() {
        return this.movementState;
    }

    public double getParam1() {
        return this.param1;
    }

    public double getParam2() {
        return this.param2;
    }

    public double getParam3() {
        return this.param3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("                  ");
        stringBuffer.replace(0, this.getName().length(), this.getName());
        NumberFormat numberFormat = NumberFormat.getPercentInstance(Locale.FRANCE);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.FRANCE);
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        String string = new String(stringBuffer) + "\t";
        string = string + this.bullets.getRounds() + "\t";
        string = this.bullets.getRounds() == 0 ? string + "---" + "\t" : string + numberFormat.format(this.bullets.getHitRate()) + "\t";
        string = string + numberFormat2.format(this.damageFrom);
        return string;
    }
}

