/*
 * Decompiled with CFR 0.152.
 */
package drm.parts;

import drm.common3.Brain;
import drm.common3.BulletStore;
import drm.common3.Coordinate;
import drm.common3.Driver;
import drm.common3.Enemy;
import drm.common3.Gun;
import drm.common3.Mech;
import drm.common3.Motor;
import drm.common3.Radar;
import drm.common3.Utils;
import drm.parts.AssaultDriver;
import java.util.Enumeration;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MeleeDriver
extends Driver {
    static final double ACC_BRK_RATE = 0.5;
    static final int CHGDRIVERCOUNT = 500;
    static final int AIMCOUNT_MAX = 30;
    public static boolean angryFlg = false;
    double maxOwnArea;
    Radar radar;
    Motor motor;
    Gun gun;
    boolean reverseFlg;
    int count;
    int chgDriverCount;
    int cdc;
    Random random;
    Enemy prevEnemy;
    double speedmax;
    double randomTh;
    int aimCount;
    boolean oneonone;
    boolean brakeFlg;
    double ownX0;
    double ownX1;
    double ownY0;
    double ownY1;

    public void init() {
        if (this.getMechas() != null) {
            this.radar = (Radar)this.getMech(0);
            this.motor = (Motor)this.getMech(1);
            this.gun = (Gun)this.getMech(2);
        }
    }

    public void initialize() {
        double y;
        double x;
        super.initialize();
        this.maxOwnArea = this.getAdvancedRobot().getBattleFieldHeight() / 8.0;
        if (this.maxOwnArea < this.getAdvancedRobot().getBattleFieldWidth() / 8.0) {
            this.maxOwnArea = this.getAdvancedRobot().getBattleFieldWidth() / 8.0;
        }
        this.motor.setSpeed(0.0);
        this.gun.setBulletPower(1.0);
        if (this.getAdvancedRobot().getX() < this.getAdvancedRobot().getBattleFieldWidth() / (double)2) {
            this.ownX0 = 0.0;
            this.ownX1 = this.getAdvancedRobot().getBattleFieldWidth() / (double)2;
            x = this.ownX0 + this.maxOwnArea;
        } else {
            this.ownX0 = this.getAdvancedRobot().getBattleFieldWidth() / (double)2;
            this.ownX1 = this.getAdvancedRobot().getBattleFieldWidth();
            x = this.ownX1 - this.maxOwnArea;
        }
        if (this.getAdvancedRobot().getY() < this.getAdvancedRobot().getBattleFieldHeight() / (double)2) {
            this.ownY0 = 0.0;
            this.ownY1 = this.getAdvancedRobot().getBattleFieldHeight() / (double)2;
            y = this.ownY0 + this.maxOwnArea;
        } else {
            this.ownY0 = this.getAdvancedRobot().getBattleFieldHeight() / (double)2;
            this.ownY1 = this.getAdvancedRobot().getBattleFieldHeight();
            y = this.ownY1 - this.maxOwnArea;
        }
        this.reverseFlg = this.random.nextBoolean();
        if (this.getAdvancedRobot().getTime() == 0L) {
            angryFlg = false;
            if (this.getAdvancedRobot().getOthers() > 1) {
                if (!this.reverseFlg) {
                    this.motor.setAheadPoint(x, y);
                } else {
                    this.motor.setAheadPoint(this.getAdvancedRobot().getX() * (double)2 - x, this.getAdvancedRobot().getY() * (double)2 - y);
                }
            }
        }
        this.cdc = 500;
        if (this.getAdvancedRobot().getOthers() == 1) {
            this.ownX0 = 0.0;
            this.ownX1 = this.getAdvancedRobot().getBattleFieldWidth();
            this.ownY0 = 0.0;
            this.ownY1 = this.getAdvancedRobot().getBattleFieldHeight();
            this.oneonone = true;
            this.cdc = 50;
        }
    }

    public void move() {
        super.move();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            if (enemy.getNewEnemyInfo().x != -99999.0 && enemy.getNewEnemyInfo().y != -99999.0 && enemy.getNewEnemyInfo().heading != -99999.0 && enemy.getNewEnemyInfo().velocity != -99999.0 && enemy.getNewEnemyInfo().distance != -99999.0 && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
                this.aim(enemy);
                if (this.prevEnemy != enemy) {
                    this.chgDriverCount = 0;
                }
                boolean cfr_ignored_0 = enemy.isFired;
            }
        } else {
            this.aimCancel();
        }
        this.accelAndBrake();
        ++this.count;
        if (this.motor.getSpeed() == 0.0) {
            this.reverse();
            this.count = 0;
            this.speedmax = 32.0 + this.random.nextDouble() * 32.0;
            this.randomTh = 1.0 + this.random.nextDouble() * 6.0;
        }
        if ((double)(this.count % 8) < this.random.nextDouble() * this.randomTh) {
            this.motor.setTurn(Utils.getRobotMaxTurning(this.getAdvancedRobot().getVelocity()));
        } else {
            this.motor.setTurn(-Utils.getRobotMaxTurning(this.getAdvancedRobot().getVelocity()));
        }
        this.changeDriver();
        this.prevEnemy = enemy;
    }

    void changeDriver() {
        if (!angryFlg && this.getAdvancedRobot().getOthers() == 1 || this.chgDriverCount++ > this.cdc) {
            if (this.chgDriverCount++ > this.cdc) {
                System.out.println("Timeout.");
            }
            this.motor.resetTargetPoint();
            this.motor.resetAheadPoint();
            angryFlg = false;
            this.setNextDriver(new AssaultDriver(this.getAdvancedRobot(), this.getMechas(), this.getBrain()));
        }
    }

    void accelAndBrake() {
        double deg = this.getAdvancedRobot().getHeading();
        double sp = this.motor.getSpeed();
        if (this.reverseFlg) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (this.chkHitEnemy(deg, 100.0, (Robot)this.getAdvancedRobot()) || this.chkHitBullet(deg, 100.0, (Robot)this.getAdvancedRobot()) && (double)this.count > this.speedmax * 0.5 / (double)3 || this.chkOutOfBattleField(deg, this.maxOwnArea, (Robot)this.getAdvancedRobot()) || (double)this.count > this.speedmax * 0.5 || this.brakeFlg) {
            this.brake();
        } else {
            this.accel();
        }
    }

    void brake() {
        double bsp = this.motor.getSpeed();
        double asp = Math.abs(bsp);
        if (asp > 0.0) {
            asp -= (double)2;
        }
        if (this.reverseFlg) {
            asp = -asp;
        }
        this.motor.setSpeed(asp);
    }

    void heavyBrake() {
        double sp = this.motor.getSpeed();
        if (sp != 0.0) {
            this.motor.setSpeed(0.0);
        }
    }

    void accel() {
        double bsp = this.motor.getSpeed();
        double asp = Math.abs(bsp);
        if (asp < 8.0) {
            asp += (double)2;
        }
        if (this.reverseFlg) {
            asp = -asp;
        }
        this.motor.setSpeed(asp);
    }

    void reverse() {
        double speed = this.motor.getSpeed();
        double deg = this.getAdvancedRobot().getHeading();
        if (!this.reverseFlg) {
            deg = Utils.normalAbsoluteAngle(deg + 180.0);
        }
        if (!this.chkOutOfBattleField(deg, 100.0, (Robot)this.getAdvancedRobot())) {
            this.motor.setSpeed(-speed);
            this.reverseFlg ^= true;
        }
        this.brakeFlg = false;
    }

    boolean chkOutOfBattleField(double heading, double distance, Robot robot) {
        boolean ret = false;
        double robotR = Utils.getRobotR();
        double x = robot.getX() + distance * Math.sin(Math.toRadians(heading));
        double y = robot.getY() + distance * Math.cos(Math.toRadians(heading));
        if (x < this.ownX0 + robotR || x > this.ownX1 - robotR || y < this.ownY0 + robotR || y > this.ownY1 - robotR) {
            ret = true;
        }
        return ret;
    }

    boolean chkHitEnemy(double heading, double distance, Robot robot) {
        boolean ret = false;
        double x = robot.getX();
        double y = robot.getY();
        Enumeration en = this.getBrain().getEnemyList().elements();
        while (en.hasMoreElements()) {
            double ey;
            double ex;
            double deg;
            Enemy enemy = (Enemy)en.nextElement();
            if (!enemy.isAlive || enemy.getNewEnemyInfo().x == -99999.0 || enemy.getNewEnemyInfo().y == -99999.0 || !(Math.abs(Utils.normalRelativeAngle(heading - (deg = Math.toDegrees(Math.atan2((ex = enemy.getNewEnemyInfo().x) - x, (ey = enemy.getNewEnemyInfo().y) - y))))) < 30.0) || !(Utils.calcDistance(x, y, ex, ey) < distance)) continue;
            this.motor.setTargetPoint(ex, ey);
            ret = true;
            break;
        }
        return ret;
    }

    boolean chkHitBullet(double heading, double distance, Robot robot) {
        boolean ret = false;
        double robotx = robot.getX();
        double roboty = robot.getY();
        double robotvel = robot.getVelocity();
        double robotR = Utils.getRobotR();
        double hheading = heading;
        double deltaHeading = this.getBrain().getDeltaHeading();
        Enemy enemy = this.getBrain().getTarget();
        if (enemy == null) {
            return ret;
        }
        if (enemy.isAlive && enemy.getNewEnemyInfo().time == this.getAdvancedRobot().getTime()) {
            Enumeration en2 = enemy.bulletStoreList.elements();
            while (en2.hasMoreElements()) {
                BulletStore bs = (BulletStore)en2.nextElement();
                if (bs.distance < distance) {
                    double prevDistance = bs.distance;
                    double x = robotx + robotvel * Math.sin(Math.toRadians(hheading));
                    double y = roboty + robotvel * Math.cos(Math.toRadians(hheading));
                    double bx = bs.x + bs.velocity * Math.sin(Math.toRadians(bs.heading));
                    double by = bs.y + bs.velocity * Math.cos(Math.toRadians(bs.heading));
                    double nextDistance = Utils.calcDistance(x, y, bx, by);
                    while (nextDistance < prevDistance) {
                        prevDistance = nextDistance;
                        nextDistance = Utils.calcDistance(x += robotvel * Math.sin(Math.toRadians(hheading)), y += robotvel * Math.cos(Math.toRadians(hheading)), bx += bs.velocity * Math.sin(Math.toRadians(bs.heading)), by += bs.velocity * Math.cos(Math.toRadians(bs.heading)));
                        if (!(nextDistance < robotR)) continue;
                        this.motor.setTargetPoint(bs.x, bs.y);
                        ret = true;
                        break;
                    }
                }
                if (ret) break;
            }
        }
        return ret;
    }

    void aim(Enemy enemy) {
        double x = enemy.getNewEnemyInfo().x;
        double y = enemy.getNewEnemyInfo().y;
        double bulletPower = 3;
        double myEnergy = this.getAdvancedRobot().getEnergy();
        if (myEnergy < bulletPower) {
            bulletPower = 0.1;
        }
        Coordinate impactPoint = null;
        impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(enemy, enemy, this.getBrain().myStoreList, bulletPower);
        if (impactPoint == null && Brain.enemyListBak != null) {
            Enemy prevRoundEnemy = (Enemy)Brain.enemyListBak.get(enemy.name);
            impactPoint = this.getBrain().getLogTraceEnemyImpactPoint(prevRoundEnemy, enemy, Brain.myStoreListBak, bulletPower);
            boolean bl = false;
            if (impactPoint != null) {
                bl = true;
            }
        }
        if (impactPoint == null) {
            impactPoint = this.getBrain().getCircuitEnemyImpactPoint(enemy, bulletPower);
            if (this.random.nextDouble() < 0.0) {
                double mx = this.getAdvancedRobot().getX();
                double my = this.getAdvancedRobot().getY();
                double delta = enemy.deltaShoot / Utils.getBulletVelocity(bulletPower) * Utils.calcDistance(mx, my, x, y);
                if (Utils.normalRelativeAngle(Utils.calcAbsoluteBearing(mx, my, x, y) - Utils.calcAbsoluteBearing(mx, my, impactPoint.x, impactPoint.y)) < 0.0) {
                    delta = -delta;
                }
                this.gun.setDelta(delta);
            } else {
                this.gun.setDelta(0.0);
            }
        }
        if (enemy.getNewEnemyInfo().energy != 0.0 && myEnergy < 1.0) {
            impactPoint = null;
        }
        this.gun.setBulletPower(bulletPower);
        if (this.oneonone || this.aimCount++ < 30) {
            this.radar.setTargetPoint(x, y);
        } else {
            this.aimCount = 0;
        }
        if (impactPoint != null && impactPoint.x > 0.0 && impactPoint.x < this.getAdvancedRobot().getBattleFieldWidth() && impactPoint.y > 0.0 && impactPoint.y < this.getAdvancedRobot().getBattleFieldHeight()) {
            this.gun.setTargetPoint(impactPoint.x, impactPoint.y);
        }
    }

    void aimCancel() {
        this.radar.resetTargetPoint();
        this.motor.resetTargetPoint();
        this.gun.resetTargetPoint();
    }

    public double getMaxOwnArea() {
        return this.maxOwnArea;
    }

    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        super.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        super.onBulletMissed(e);
    }

    public void onDeath(DeathEvent e) {
        super.onDeath(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        super.onHitByBullet(e);
        Bullet bullet = e.getBullet();
        this.motor.setTargetPoint(bullet.getX(), bullet.getY());
        Enemy enemy = this.getBrain().getTarget();
        if (enemy != null) {
            e.getName().equals(enemy.name);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
        this.heavyBrake();
    }

    public void onHitWall(HitWallEvent e) {
        super.onHitWall(e);
        this.reverse();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        super.onRobotDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
    }

    public void onWin(WinEvent e) {
        super.onWin(e);
    }

    private final /* synthetic */ void this() {
        this.reverseFlg = false;
        this.count = 0;
        this.chgDriverCount = 0;
        this.random = new Random();
        this.prevEnemy = null;
        this.speedmax = 64.0;
        this.randomTh = 4;
        this.aimCount = 0;
        this.oneonone = false;
        this.brakeFlg = false;
    }

    public MeleeDriver() {
        this.this();
        this.init();
    }

    public MeleeDriver(AdvancedRobot r) {
        super(r);
        this.this();
        this.init();
    }

    public MeleeDriver(AdvancedRobot r, Mech[] m) {
        super(r, m);
        this.this();
        this.init();
    }

    public MeleeDriver(AdvancedRobot r, Mech[] m, Brain b) {
        super(r, m, b);
        this.this();
        this.init();
    }
}

