/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.DC;

import de._4geeks.robots.guns.DC.Info;
import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.guns.manager.Wave;
import java.io.Serializable;

public class EnemyInfo
implements Info,
Serializable {
    public static final long serialVersionUID = 7892368253L;
    private double[] features;
    private double gf;
    private double distanceChange;
    private int hits = 0;
    private int roundNum;
    private long fireTime;
    private EnemyScan enemy;

    public EnemyInfo() {
    }

    public EnemyInfo(double[] features, double gf) {
        this.features = features;
        this.gf = gf;
    }

    public EnemyInfo(double[] features, double gf, double distance) {
        this.features = features;
        this.gf = gf;
        this.distanceChange = distance;
    }

    public EnemyInfo(Wave wave) {
        this.features = wave.getFeatures();
        this.gf = wave.getGuessFactor();
        this.distanceChange = wave.getDistanceChange();
        this.roundNum = wave.getRound();
        this.fireTime = wave.getFireTime();
        this.enemy = wave.getEnemy();
    }

    public EnemyInfo(Wave wave, double[] features) {
        this.features = features;
        this.gf = wave.getGuessFactor();
        this.distanceChange = wave.getDistanceChange();
        this.roundNum = wave.getRound();
        this.fireTime = wave.getFireTime();
        this.enemy = wave.getEnemy();
    }

    public void setGuessFactor(double gf) {
        this.gf = gf;
    }

    public double getGuessFactor() {
        return this.gf;
    }

    public double getFeature(int i) {
        return this.features[i];
    }

    public double[] getFeatures() {
        return this.features;
    }

    public void addHit() {
        ++this.hits;
    }

    public int getHits() {
        return this.hits;
    }

    public double getDistance(double[] feats) {
        double distance = 0.0;
        int i = 0;
        while (i < feats.length) {
            distance += this.sqr(this.features[i] - feats[i]);
            ++i;
        }
        return distance;
    }

    public double getDistance(double[] feats, double[] weights) {
        double distance = 0.0;
        int i = 0;
        while (i < feats.length) {
            distance += this.sqr(this.features[i] - feats[i]) * weights[i];
            ++i;
        }
        return distance;
    }

    private double sqr(double val) {
        return val * val;
    }

    public double getDistance() {
        return this.distanceChange;
    }

    public int getRoundNum() {
        return this.roundNum;
    }

    public long getFireTime() {
        return this.fireTime;
    }

    public EnemyScan getEnemy() {
        return this.enemy;
    }
}

