/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import java.util.ArrayList;
import java.util.Collections;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import rz.a.AbstractRobot;
import rz.a.Comparator;
import rz.a.Point;
import rz.a.Statistics;
import rz.a.Store;

public class Enemy {
    private static final int MAX_BEST_SIZE = 50;
    private static AbstractRobot ar;
    private static final int MAX_VALUE = 1000000;
    private static final int[] SAMPLE_CHOICE_ONEONONE;
    private static final int[] SAMPLE_CHOICE_MELEE;
    private static final int MAX_SAMPLES_ONEONONE = 10000;
    private static final int MAX_SAMPLES_MELEE = 7000;
    private static int[] sampleChoice;
    public ArrayList pattern;
    public Statistics statistics;
    public String name;
    public Point pos;
    public Point lastPos;
    public double energy;
    public double velocity;
    public double acceleration;
    public double heading;
    public double fireSpeed;
    public long scanTime;
    public boolean isLeader;
    public boolean justFired;
    public boolean live;
    public double distToMe;
    public double angleToMe;
    public double minDistance;
    public double dangerFactor;
    public double hitFactor;
    public Enemy minElement;
    public double minBearingClockwise;

    public void initBattle(AbstractRobot ar, ScannedRobotEvent e) {
        Enemy.ar = ar;
        sampleChoice = AbstractRobot.melee ? SAMPLE_CHOICE_MELEE : SAMPLE_CHOICE_ONEONONE;
        this.pattern = new ArrayList(2000 + (AbstractRobot.melee ? 7000 : 10000));
        this.name = e.getName();
        this.pos = new Point(ar.getX(), ar.getY(), e.getDistance(), ar.getHeadingRadians() + e.getBearingRadians());
        this.lastPos = new Point(ar.getX(), ar.getY(), e.getDistance(), ar.getHeadingRadians() + e.getBearingRadians());
        boolean bl = false;
        if (e.getEnergy() > 190.0) {
            bl = true;
        }
        this.isLeader = bl;
        this.hitFactor = 0.0;
        this.statistics = new Statistics(ar);
        this.statistics.initNewRound();
    }

    public void initNewRound() {
        int maxSize;
        int size = this.pattern.size() - 1;
        if (size > 100) {
            int i = size;
            while (i > size - 100) {
                ((Store)this.pattern.get((int)i)).goodEnough = false;
                --i;
            }
        }
        int n = maxSize = AbstractRobot.melee ? 7000 : 10000;
        if (size > maxSize) {
            this.pattern.subList(0, size - maxSize + 1).clear();
        }
        this.statistics.initNewRound();
        this.energy = 100.0;
        this.fireSpeed = 11.0;
        this.scanTime = 0L;
        this.justFired = false;
        this.live = false;
        this.hitFactor = 0.0;
    }

    public void scanUpdate(ScannedRobotEvent e) {
        double myX = ar.getX();
        double myY = ar.getY();
        Point p = new Point(myX, myY, e.getDistance(), ar.getHeadingRadians() + e.getBearingRadians());
        this.acceleration = e.getVelocity() - this.velocity;
        this.velocity = e.getVelocity();
        this.heading = e.getHeadingRadians();
        if (!ar.isTeammate(this.name)) {
            boolean bl = false;
            if (ar.getTime() > (long)(10 + sampleChoice[sampleChoice.length - 2])) {
                bl = true;
            }
            boolean good = bl;
            long diff = ar.getTime() - this.scanTime;
            if (this.live && diff > 1L) {
                double travel = this.pos.distance(p);
                double angle = this.pos.bearingTo(p);
                int i = 1;
                while ((long)i < diff) {
                    Point interpolatedPoint = this.pos.projectPoint(travel * (double)i / (double)diff, angle);
                    double d = interpolatedPoint.distance(myX, myY);
                    double d2 = AbstractRobot.distToWall(interpolatedPoint);
                    double d3 = AbstractRobot.distToCorner(interpolatedPoint);
                    boolean bl2 = false;
                    if (AbstractRobot.others == 1) {
                        bl2 = true;
                    }
                    this.pattern.add(new Store(this.pattern, sampleChoice, interpolatedPoint, d, d2, d3, good, bl2));
                    ++i;
                }
            }
            double d = p.distance(myX, myY);
            double d4 = AbstractRobot.distToWall(p);
            double d5 = AbstractRobot.distToCorner(p);
            boolean bl3 = false;
            if (AbstractRobot.others == 1) {
                bl3 = true;
            }
            this.pattern.add(new Store(this.pattern, sampleChoice, p, d, d4, d5, good, bl3));
        }
        this.lastPos.x = this.pos.x;
        this.lastPos.y = this.pos.y;
        this.pos.x = p.x;
        this.pos.y = p.y;
        this.justFired = false;
        double dEnergy = this.energy - e.getEnergy();
        if (0.1 <= dEnergy && dEnergy <= (double)3) {
            this.justFired = true;
            this.fireSpeed = 20.0 - (double)3 * dEnergy;
        }
        this.energy = e.getEnergy();
        this.scanTime = ar.getTime();
        this.live = true;
        if (AbstractRobot.others == 1) {
            this.statistics.scanUpdate(this);
        }
    }

    public void hitRobotUpdate(HitRobotEvent e) {
        this.energy = e.getEnergy();
    }

    public void hitByBulletUpdate(HitByBulletEvent e) {
        this.hitFactor = Math.min(1.0 + this.hitFactor, (double)3);
        this.energy += e.getPower() * (double)3;
        if (AbstractRobot.others == 1) {
            this.statistics.hitByBullet(e.getHeadingRadians(), e.getPower());
        }
    }

    public Point getAimPos(double firePower) {
        ArrayList<Comparator> best = new ArrayList<Comparator>(50);
        double[][] positions = new double[3][50];
        int posIndex = 0;
        double speed = 20.0 - (double)3 * firePower;
        try {
            if (this.energy > 0.0) {
                Comparator worst = new Comparator(1000000, -1);
                best.add(worst);
                int pSize = this.pattern.size() - 1;
                Store sNow = (Store)this.pattern.get(pSize);
                int bestSize = (int)AbstractRobot.limit(12.0, (double)pSize / 100.0, 50.0);
                int endIndex = sampleChoice[sampleChoice.length - 1];
                int deepIndex = ar.getTime() > (long)sampleChoice[sampleChoice.length - 1] ? sampleChoice.length : (ar.getTime() > (long)sampleChoice[sampleChoice.length - 2] ? sampleChoice.length - 1 : sampleChoice.length - 2);
                int i = pSize - 100;
                while (i > endIndex) {
                    int value = ((Store)this.pattern.get(i)).evalPat(sNow, deepIndex);
                    if (best.size() < bestSize) {
                        best.add(new Comparator(value, i));
                    } else if (value < worst.value) {
                        best.add(new Comparator(value, i));
                        best.remove(worst);
                        worst = (Comparator)Collections.max(best);
                    }
                    --i;
                }
                Collections.sort(best);
                int i2 = 0;
                while (i2 < best.size()) {
                    Comparator c = (Comparator)best.get(i2);
                    int index = c.index;
                    if (c.value < 1000000) {
                        double patX = this.pos.x;
                        double patY = this.pos.y;
                        Store s = (Store)this.pattern.get(index);
                        double rotAngle = sNow.heading - s.heading;
                        double travel = 0.0;
                        do {
                            s = (Store)this.pattern.get(++index);
                        } while ((travel += speed) < AbstractRobot.myPos.distance(patX += s.velocity * Math.sin(s.heading + rotAngle), patY += s.velocity * Math.cos(s.heading + rotAngle)) + speed / (double)2);
                        if (AbstractRobot.distToWall(patX, patY) > 16.0) {
                            positions[0][posIndex] = patX;
                            positions[1][posIndex] = patY;
                            positions[2][posIndex] = Math.atan2(patX - AbstractRobot.myPos.x, patY - AbstractRobot.myPos.y);
                            ++posIndex;
                        }
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            Enemy.ar.out.println("" + ar.getTime() + ' ' + e);
        }
        double offsetSize = 30.0 / AbstractRobot.myPos.distance(this.pos);
        int bestIndex = -1;
        int bestCount = 0;
        int i = 0;
        while (i < posIndex) {
            int count = 0;
            int j = 0;
            while (j < posIndex) {
                if (Math.abs(AbstractRobot.normalAngle(positions[2][i] - positions[2][j])) < offsetSize) {
                    ++count;
                }
                ++j;
            }
            if (bestCount < count) {
                bestIndex = i;
                bestCount = count;
            }
            ++i;
        }
        if (bestIndex == -1) {
            best = null;
            positions = null;
            return this.pos;
        }
        double bestX = positions[0][bestIndex];
        double bestY = positions[1][bestIndex];
        best = null;
        positions = null;
        return new Point(bestX, bestY);
    }

    static {
        SAMPLE_CHOICE_ONEONONE = new int[]{1, 4, 8, 16, 32, 64};
        SAMPLE_CHOICE_MELEE = new int[]{1, 3, 9, 27, 81};
    }
}

