/*
 * Decompiled with CFR 0.152.
 */
package mb.utils;

import mb.core.Coordinates;

public class CoordinatesUtils {
    public static Coordinates addVectors(Coordinates a, Coordinates b) {
        return new Coordinates(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static double getDistance(Coordinates point1, Coordinates point2) {
        double a = Math.abs(point1.getX() - point2.getX());
        double b = Math.abs(point1.getY() - point2.getY());
        double c = Math.sqrt(a * a + b * b);
        return c;
    }

    public static double getAngle(Coordinates point1, Coordinates point2) {
        return Math.toDegrees(Math.acos(CoordinatesUtils.scalarProduct(point1, point2) / (point1.getLength() * point2.getLength())));
    }

    public static Coordinates getNormalizedVector(Coordinates diff, double angle) {
        double sinAngle = Math.sin(angle);
        double cosAngle = Math.cos(angle);
        double normalizedX = diff.getX() * cosAngle - diff.getY() * sinAngle;
        double normalizedY = diff.getX() * sinAngle + diff.getY() * cosAngle;
        Coordinates normalizedVector = new Coordinates(normalizedX, normalizedY);
        return normalizedVector;
    }

    private static double scalarProduct(Coordinates point1, Coordinates point2) {
        return point1.getX() * point2.getX() + point1.getY() * point2.getY();
    }
}

