/*
 * Decompiled with CFR 0.152.
 */
package mb;

import mb.MBRobot;
import mb.guns.GFGun;
import mb.guns.HeadOnTargetGun;
import mb.movement.DistanceBasedDodgingMovement;
import mb.movement.DodgingMovement;
import mb.movement.WallSmoother;
import mb.radar.NarrowLockRadar;
import mb.utils.PaintUtils;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;

public class Monte
extends MBRobot {
    private static int best = 0;
    private static int hits = 0;
    private static int hitBy = 0;
    private static int testWin = 0;
    private static int testLoss = 0;
    private static int testrounds = 0;
    private static int[] hitByData = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    private static double[] hitHitByRatio = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};

    public void onHitRobot(HitRobotEvent event) {
        this.movements.onHitRobot(event);
        super.onHitRobot(event);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        if (event.getEnergy() == 0.0) {
            this.gun = new HeadOnTargetGun(this);
        }
        this.gun.onScannedRobot(event);
        this.paintVectors(event);
        this.radar.onScannedRobot(event);
        this.movements.onScannedRobot(event);
        if (this.hasEnemyFired(event)) {
            this.movements.onRobotFired(event);
        } else {
            this.gun.fire(event);
        }
        this.enemyEnergy = event.getEnergy();
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
        System.out.println(testrounds);
        this.movements.printMovements();
        if (testrounds == 0) {
            this.storeTestData();
            this.movements.remove(DodgingMovement.class);
            this.resetTestData();
        } else if (testrounds == 1) {
            this.storeTestData();
            this.addMovement(testrounds);
            this.resetTestData();
        } else if (testrounds == 2) {
            this.storeTestData();
            this.movements.remove(DistanceBasedDodgingMovement.class);
            this.resetTestData();
        } else if (testrounds == 3) {
            this.storeTestData();
            this.movements.remove(DodgingMovement.class);
            this.selectBestMovement();
        }
        this.movements.printMovements();
        ++testrounds;
        if (this.isNext() && testLoss > testWin) {
            this.movements.remove(DodgingMovement.class);
            this.movements.remove(DistanceBasedDodgingMovement.class);
            testrounds = 0;
            this.addMovement(testrounds);
        } else if (this.isNext()) {
            testLoss = 0;
            testWin = 0;
        }
        super.onRoundEnded(event);
    }

    private boolean isNext() {
        return testrounds % 7 == 0;
    }

    private void storeTestData() {
        Monte.hitByData[Monte.testrounds] = hitBy;
        Monte.hitHitByRatio[Monte.testrounds] = (double)hits / (double)hitBy;
    }

    private void selectBestMovement() {
        int minHitBy = 10000;
        double maxRatio = 0.0;
        boolean indifferent = false;
        int i = 0;
        while (i < hitByData.length) {
            System.out.print(String.valueOf(hitByData[i]) + " ");
            if (hitByData[i] < minHitBy) {
                minHitBy = hitByData[i];
                best = i;
            }
            if (hitByData[i] == minHitBy) {
                indifferent = true;
            }
            ++i;
        }
        if (indifferent) {
            i = 0;
            while (i < hitHitByRatio.length) {
                System.out.print(String.valueOf(hitHitByRatio[i]) + " ");
                if (hitHitByRatio[i] > maxRatio) {
                    maxRatio = hitHitByRatio[i];
                    best = i;
                }
                ++i;
            }
        }
        System.out.println("Best: " + best);
        this.addMovement(best);
    }

    private void addMovement(int tactic) {
        if (tactic == 0) {
            this.movements.add(new DodgingMovement(this, 20));
        } else if (tactic == 2) {
            this.movements.add(new DistanceBasedDodgingMovement(this));
        } else if (tactic == 3) {
            this.movements.add(new DodgingMovement(this, 40));
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        ++hits;
        super.onBulletHit(event);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        ++hitBy;
        super.onHitByBullet(event);
    }

    @Override
    public void onDeath(DeathEvent event) {
        ++testLoss;
        super.onDeath(event);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        ++testWin;
        super.onRobotDeath(event);
    }

    @Override
    protected void init() {
        this.paintUtils = new PaintUtils(this.getGraphics());
        this.gun = new GFGun(this);
        this.radar = new NarrowLockRadar(this);
        this.movements.add(new WallSmoother(this));
        if (testrounds < 4) {
            this.addMovement(testrounds);
        } else {
            this.addMovement(best);
        }
    }

    private void resetTestData() {
        hits = 0;
        hitBy = 0;
    }
}

