/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import jbot.Rabbit2;
import jbot.tracer.Target;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.Rules;

public class MultiAvgTechnique
extends TracerTechnique {
    static final double NEW_SPEED_FACTOR_WEIGHT = 0.01;
    static final double NEW_SIGN_FACTOR_WEIGHT = 0.6;
    static final int FORWARD = 1;
    static final int BACK = 0;
    static final int INCREASE = 1;
    static final int DECREASE = 0;
    double[] mAvgSpeed = new double[2];
    double[] mAvgAngleSpeed = new double[2];
    double[] mAvgKeep = new double[2];
    double[] mAvgAngleKeep = new double[2];
    int mCurrentDirSign;
    int mLastDirSign;
    long mLastDirChangeTime;
    int mCurrentAngleSign;
    int mLastAngleSign;
    long mLastAngleChangeTime;

    public MultiAvgTechnique(String techName, Rabbit2 bot, Target self, Target target, double initialEfficient, double learnFactor) {
        super(techName, bot, self, target, initialEfficient, learnFactor);
        this.mColor = Color.ORANGE;
        this.mAvgSpeed[1] = 4.0;
        this.mAvgSpeed[0] = -4.0;
        this.mAvgAngleSpeed[1] = 0.0;
        this.mAvgAngleSpeed[0] = 0.0;
        this.mAvgKeep[1] = 0.0;
        this.mAvgKeep[0] = 0.0;
        this.mAvgAngleKeep[1] = 0.0;
        this.mAvgAngleKeep[0] = 0.0;
        this.mCurrentDirSign = 1;
        this.mLastDirSign = 1;
        this.mLastDirChangeTime = 0L;
        this.mCurrentAngleSign = 1;
        this.mLastAngleSign = 1;
        this.mLastAngleChangeTime = 0L;
    }

    public void frameLogic(double deltaTime) {
        double newWeight = 0.01 * deltaTime * this.getEfficient();
        double oldWeight = 1.0 - newWeight;
        double newSignWeight = 0.6 * deltaTime * this.getEfficient();
        double oldSignWeight = 1.0 - newSignWeight;
        this.mLastDirSign = this.mCurrentDirSign;
        if (MathUtil.cmp(this.mTarget.getSpeed(), 0.0) > 0) {
            this.mCurrentDirSign = 1;
        } else if (MathUtil.cmp(this.mTarget.getSpeed(), 0.0) < 0) {
            this.mCurrentDirSign = 0;
        }
        if (this.mCurrentDirSign != this.mLastDirSign) {
            this.mAvgKeep[this.mLastDirSign] = oldSignWeight * this.mAvgKeep[this.mLastDirSign] + newSignWeight * (1.0 / (double)(this.getRecentTime() - this.mLastDirChangeTime));
            this.mLastDirChangeTime = this.getRecentTime();
        }
        if (this.mTarget.getSpeed() != 0.0) {
            this.mAvgSpeed[this.mCurrentDirSign] = oldWeight * this.mAvgSpeed[this.mCurrentDirSign] + newWeight * this.mTarget.getSpeed();
        } else {
            this.mAvgSpeed[0] = (oldWeight + newWeight / 2.0) * this.mAvgSpeed[0];
            this.mAvgSpeed[1] = (oldWeight + newWeight / 2.0) * this.mAvgSpeed[1];
        }
        if (this.mCurrentAngleSign != this.mLastAngleSign) {
            this.mAvgAngleKeep[this.mLastAngleSign] = oldSignWeight * this.mAvgAngleKeep[this.mLastAngleSign] + newSignWeight * (1.0 / (double)(this.getRecentTime() - this.mLastAngleChangeTime));
            this.mLastAngleChangeTime = this.getRecentTime();
        }
        this.mAvgAngleSpeed[this.mCurrentAngleSign] = oldWeight * this.mAvgAngleSpeed[this.mCurrentAngleSign] + newWeight * this.mTarget.getAngleVel();
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        double bulletSpeed = Rules.getBulletSpeed((double)shootPower);
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        int currSign = this.mCurrentDirSign;
        long currKeep = shootTime - this.mLastDirChangeTime;
        double v = this.mAvgSpeed[currSign];
        double a = target.getDirectionAngle();
        Vector2 dir = new Vector2(a);
        Vector2 distance = target.getPosition().sub(shootPos);
        this.mEstimatedPath.clear();
        int t = 0;
        do {
            ++t;
            if (this.mAvgKeep[currSign] * (double)(++currKeep) > 1.0) {
                currKeep = 1L;
                currSign = currSign == 1 ? 0 : 1;
            }
            v = this.mAvgSpeed[currSign];
            Vector2 offset = dir.clone().multiply(v);
            distance.add(offset);
            this.mEstimatedPath.add(distance.clone().add(shootPos));
        } while (!(distance.getLength() / bulletSpeed > (double)t - 1.0 && distance.getLength() / bulletSpeed < (double)t + 1.0) && t <= 40);
        return distance.getAngle();
    }

    public String prepareLogString() {
        String log = "\n Avg Speed [FORWARD] = " + this.mAvgSpeed[1] + "\n Avg Speed [BACK] = " + this.mAvgSpeed[0] + "\n Avg Keep [FORWARD] = " + this.mAvgKeep[1] + "\n Avg Keep [BACK] = " + this.mAvgKeep[0] + "\n Avg Angle Speed [INCREASE] = " + this.mAvgAngleSpeed[1] + "\n Avg Angle Speed [DECREASE] = " + this.mAvgAngleSpeed[0] + "\n Avg Angle Keep [INCREASE] = " + this.mAvgAngleKeep[1] + "\n Avg Angle Keep [DECREASE] = " + this.mAvgAngleKeep[0];
        return log;
    }
}

