/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import pedersen.core.Conversions;
import pedersen.physics.StaticPosition;

public class Constraints {
    public static final double maxFirepower = 3.0;
    public static final double minFirepower = 0.1;
    public static final double maxBulletVelocity = 19.7;
    public static final double minBulletVelocity = 11.0;
    public static final double maxAbsVehicleVelocity = 8.0;
    public static final double zeroVelocity = 0.0;
    public static final double maxAbsVehicularTurnRate = Conversions.getAbsMaxTurnRateFromVelocity(0.0);
    public static final double maxAbsTurretTurnRate = 0.3490658503988659;
    public static final double maxAbsRadarTurnRate = 0.7853981633974483;
    public static final double maxAbsVehicularAcceleration = 1.0;
    public static final double maxAbsVehicularDeceleration = 2.0;
    public static final double maxEscapeAngle = Math.atan(0.7272727272727273);
    public static final double halfCircle = Math.PI;
    public static final double fullCircle = Math.PI * 2;
    public static final double rightAngle = 1.5707963267948966;
    public static final double doubleErrorTolerance = 1.0E-7;
    public static final boolean allowFileIO = true;

    public static boolean isFirepowerLegal(double firepower) {
        return Constraints.isInRange(0.1, firepower, 3.0);
    }

    public static double getClosestLegalFirepower(double firepower) {
        return Constraints.getClosestLegalValue(0.1, firepower, 3.0);
    }

    public static boolean isBulletVelocityInRange(double velocity) {
        return Constraints.isInRange(11.0, velocity, 19.7);
    }

    public static double getClosestLegalBulletVelocity(double velocity) {
        return Constraints.getClosestLegalValue(11.0, velocity, 19.7);
    }

    public static boolean isVehicularTurnRateLegal(double turnRate) {
        return Constraints.isInRange(-maxAbsVehicularTurnRate, turnRate, maxAbsVehicularTurnRate);
    }

    public static double getClosestLegalVehicularTurnRate(double turnRate) {
        return Constraints.getClosestLegalTurnRate(turnRate, maxAbsVehicularTurnRate);
    }

    public static double getClosestLegalTurnRate(double turnRate, double maximumTurnRate) {
        return Constraints.getClosestLegalValue(-maximumTurnRate, turnRate, maximumTurnRate);
    }

    public static boolean isVehicularVelocityLegal(double velocity) {
        return Constraints.isInRange(-8.0, velocity, 8.0);
    }

    public static double getClosestLegalVehicularVelocity(double velocity) {
        return Constraints.getClosestLegalValue(-8.0, velocity, 8.0);
    }

    public static boolean isInRange(double minimum, double value, double maximum) {
        return minimum <= value && value <= maximum;
    }

    public static boolean isInRange(int minimum, int value, int maximum) {
        return minimum <= value && value <= maximum;
    }

    public static double getClosestLegalValue(double minimum, double value, double maximum) {
        value = Math.max(value, minimum);
        value = Math.min(value, maximum);
        return value;
    }

    public static int getClosestLegalValue(int minimum, int value, int maximum) {
        value = Math.max(value, minimum);
        value = Math.min(value, maximum);
        return value;
    }

    public static double getClosestLegalVehicularAcceleration(double acceleration) {
        return Constraints.getClosestLegalValue(-1.0, acceleration, 1.0);
    }

    public static double getClosestLegalVehicularDeceleration(double deceleration) {
        return Constraints.getClosestLegalValue(-2.0, deceleration, 2.0);
    }

    public static double getNegativePiToPi(double radians) {
        if ((radians %= Math.PI * 2) > Math.PI) {
            radians -= Math.PI * 2;
        } else if (-radians > Math.PI) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static double getZeroToTwoPi(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public static boolean areEqual(double a, double b) {
        return Constraints.isApproximatelyZero(b - a);
    }

    public static boolean isApproximatelyZero(double delta) {
        return Math.abs(delta) < 1.0E-7;
    }

    public static boolean doesBulletIntersectRobot(StaticPosition robotPosition, Line2D.Double bulletLineSegment) {
        Rectangle2D.Double robotBoundingRectangle = Conversions.getRectangle2DForRobot(robotPosition);
        boolean bulletIntersectsRobot = bulletLineSegment.intersects(robotBoundingRectangle);
        return bulletIntersectsRobot;
    }

    public static boolean isRelativeHeadingToRear(double relativeHeading) {
        return !Constraints.isInRange(-1.5707963267948966, relativeHeading, 1.5707963267948966);
    }
}

