/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.StaticHeading;

public class StaticHeadingImpl
implements StaticHeading {
    private final double heading;

    public StaticHeadingImpl(double newHeading) {
        this.heading = newHeading;
    }

    public StaticHeadingImpl(StaticHeading other) {
        this.heading = other.getHeading();
    }

    public double getHeading() {
        return this.heading;
    }

    public double getRelativeAngle(double other) {
        return StaticHeadingImpl.getRelativeAngle(this.heading, other);
    }

    public double getCompoundAngle(double other) {
        return StaticHeadingImpl.getCompoundAngle(this.heading, other);
    }

    public static double getRelativeAngle(double a, double b) {
        return Constraints.getNegativePiToPi(b - a);
    }

    public static double getCompoundAngle(double a, double b) {
        return Constraints.getZeroToTwoPi(a + b);
    }

    public static double getTangentAngle(double a) {
        return StaticHeadingImpl.getCompoundAngle(a, 1.5707963267948966);
    }

    public static double getOpposedAngle(double a) {
        return StaticHeadingImpl.getCompoundAngle(a, Math.PI);
    }

    public void debug() {
        Debug.debug("Static heading: " + this.getHeading());
    }
}

