/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pedersen.core.GameState;
import pedersen.debug.Metrics;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.opponent.Target;
import pedersen.physics.BearingOffsetRange;
import pedersen.physics.Circle;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.HasVehicle;
import pedersen.physics.HasWave;
import pedersen.physics.Position;
import pedersen.physics.constant.CircleImpl;
import pedersen.physics.constant.WaveImpl;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnPaint;
import pedersen.util.BaseConstraints;
import pedersen.util.Constraints;

public abstract class BaseCombatWave
extends WaveImpl
implements CombatWave,
OnPaint {
    protected final Map<Target, TargetAnalysis> targetAnalyses = new HashMap<Target, TargetAnalysis>();
    protected final Map<Target, Set<FiringSolution>> targetFiringSolutions = new HashMap<Target, Set<FiringSolution>>();
    protected final Set<FiringSolution> allFiringSolutions = new HashSet<FiringSolution>();
    public static long counter = 0L;
    public static long release = 0L;

    public BaseCombatWave(HasWave wave) {
        super(wave);
        ++counter;
    }

    protected abstract void recordWave();

    protected void addFiringSolutions(Target target, Set<FiringSolution> firingSolutions) {
        this.targetFiringSolutions.put(target, firingSolutions);
        this.allFiringSolutions.addAll(firingSolutions);
        Metrics.getInstance().incrementFiringSolutionCount();
    }

    @Override
    public void process() {
        for (Map.Entry<Target, TargetAnalysis> e : this.targetAnalyses.entrySet()) {
            Target target = e.getKey();
            if (target.isActive()) {
                this.process(target, e.getValue());
                continue;
            }
            this.targetAnalyses.remove(target).release();
        }
    }

    public void process(HasPosition prey, TargetAnalysis targetAnalysis) {
        Position location = prey.getPosition();
        double offset = this.getRelativeBearingOffset(location, targetAnalysis);
        CircleImpl targetCircle = new CircleImpl((HasPosition)location, Constraints.vehicleRadius);
        this.recordBearingOffsetRange(GameState.getInstance().getTurn(), targetCircle, offset, targetAnalysis);
        this.recordBearingOffsetRange(GameState.getInstance().getTurnAfter(), targetCircle, offset, targetAnalysis);
    }

    private double getRelativeBearingOffset(Position position, TargetAnalysis targetAnalysis) {
        return targetAnalysis.originalBearingToTarget.getRelativeDirection(this.getPosition().getBearing(position)).getRelativeRadians();
    }

    private void recordBearingOffsetRange(long time, Circle prey, double offset, TargetAnalysis borContainer) {
        BearingOffsetRange bor = this.getCircle(time).getRangeOfIntersection(prey);
        if (bor != null) {
            bor = bor.translate(offset);
            borContainer.addRangeOfInterception(bor);
        }
    }

    @Override
    public String description() {
        return String.valueOf(this.getClass().getSimpleName()) + "\n" + super.description();
    }

    @Override
    public void paint() {
        Circle now = this.getCircle(GameState.getInstance().getTurn());
        Circle next = this.getCircle(GameState.getInstance().getTurnAfter());
        GraphicalDebugger.addCircleTurnScope(now, Color.darkGray);
        GraphicalDebugger.addCircleTurnScope(next, Color.darkGray);
        if (GraphicalDebugger.paintFiringSolutions) {
            Circle was = this.getCircle(GameState.getInstance().getTurnBefore());
            for (Map.Entry<Target, Set<FiringSolution>> e : this.targetFiringSolutions.entrySet()) {
                this.paintFiringSolutions((Iterable<FiringSolution>)e.getValue(), was, now, next);
            }
        }
    }

    private void paintFiringSolutions(Iterable<FiringSolution> c, Circle was, Circle now, Circle next) {
        for (FiringSolution e : c) {
            Position point2 = this.getPosition().addVector((HasDirection)e.getDirection(), now.getRadius());
            Position point3 = this.getPosition().addVector((HasDirection)e.getDirection(), next.getRadius());
            if (now.getRadius().radius() > 0.0) {
                Position point1 = this.getPosition().addVector((HasDirection)e.getDirection(), was.getRadius());
                GraphicalDebugger.addLineTurnScope(point1, point2, Color.yellow);
            }
            GraphicalDebugger.addLineTurnScope(point2, point3, Color.red);
        }
    }

    protected boolean isWavePastTarget(HasPosition p) {
        return this.radius(GameState.getInstance().getTurn()) > this.getPosition().getDistance(p).distance() + BaseConstraints.vehicleRadius;
    }

    @Override
    public boolean doesAnyFiringSolutionInterceptVehicleChassis(HasVehicle vehicleChassis, long time) {
        for (Map.Entry<Target, Set<FiringSolution>> e : this.targetFiringSolutions.entrySet()) {
            for (FiringSolution firingSolution : e.getValue()) {
                if (!this.doesFiringSolutionInterceptVehicleChassis(vehicleChassis, time, firingSolution)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesFiringSolutionInterceptVehicleChassis(HasVehicle vehicleChassis, long time, FiringSolution firingSolution) {
        double angle = firingSolution.getDirection().getAbsoluteRadians();
        Line2D.Double bulletLineSegment = this.getNextTurnsLineSegment(time, angle);
        Rectangle2D.Double vehicleHitbox = new Rectangle2D.Double(vehicleChassis.getVehicle().getPosition().getX() - 18.0, vehicleChassis.getVehicle().getPosition().getY() - 18.0, 36.0, 36.0);
        return bulletLineSegment.intersects(vehicleHitbox);
    }

    private Line2D.Double getNextTurnsLineSegment(long time, double angle) {
        Point2D.Double a = this.getPosition().addVector(angle, this.radius(time)).getPoint2D();
        Point2D.Double b = this.getPosition().addVector(angle, this.radius(time + 1L)).getPoint2D();
        Line2D.Double lineSegment = new Line2D.Double(a, b);
        return lineSegment;
    }

    @Override
    public Iterable<FiringSolution> getFiringSolutions() {
        return this.allFiringSolutions;
    }

    public void enablePainting() {
        if (GraphicalDebugger.paintCombatWaveBank) {
            NotificationSubsystem.getInstance().subscribeOnPaint(this);
        }
    }

    @Override
    public void teardown() {
        this.allFiringSolutions.clear();
        this.recordWave();
        this.recordAccuracy();
        NotificationSubsystem.getInstance().unsubscribeOnPaint(this);
        for (Target e : this.targetAnalyses.keySet()) {
            this.targetAnalyses.remove(e).release();
        }
        for (Target e : this.targetFiringSolutions.keySet()) {
            Iterator<FiringSolution> iterator = this.targetFiringSolutions.remove(e).iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
                iterator.remove();
            }
        }
        ++release;
    }

    protected void recordAccuracy() {
        for (Target e : this.targetAnalyses.keySet()) {
            this.recordAccuracy(e);
        }
    }

    protected void recordAccuracy(Target target) {
        TargetAnalysis targetAnalysis = this.targetAnalyses.get(target);
        BearingOffsetRange intercept = targetAnalysis.getRangeOfInterception();
        if (intercept != null) {
            Direction odc = targetAnalysis.originalBearingToTarget;
            for (FiringSolution firingSolution : this.targetFiringSolutions.get(target)) {
                double relativeFiringSolution = odc.getRelativeDirection(firingSolution.getDirection()).getRelativeRadians();
                boolean intercepted = intercept.isInRange(relativeFiringSolution);
                if (intercepted) {
                    firingSolution.registerHit(this);
                    continue;
                }
                firingSolution.registerMiss(this);
            }
        }
    }

    public double velocity() {
        return super.getVelocity().velocity();
    }
}

