/*
 * Decompiled with CFR 0.152.
 */
package bh.components.graphics;

import bh.components.history.RobotRecord;
import bh.components.history.RobotState;
import bh.components.history.analysis.BotTracker;
import bh.facade.FacadeBot;
import bh.facade.RulesFacade;
import bh.facade.event_listeners.EventType;
import bh.facade.event_listeners.defaults.DefaultAdvancedEventListener;
import java.awt.Color;
import java.awt.Graphics2D;

public class BotPainter
extends DefaultAdvancedEventListener {
    private final BotTracker.SingleCondition locTracker;
    private final String robotName;
    private Graphics2D g = null;

    public BotPainter(FacadeBot fb, BotTracker.SingleCondition locTracker) {
        fb.registerListener(EventType.PAINT, this);
        this.robotName = fb.getName();
        this.locTracker = locTracker;
    }

    public void onPaint(Graphics2D g) {
        this.g = g;
    }

    public void paint() {
        if (this.g != null) {
            Color c = this.g.getColor();
            if (c == null) {
                c = Color.WHITE;
            }
            for (String botName : this.locTracker.getKnownBots()) {
                if (botName.equals(this.robotName)) {
                    this.g.setColor(Color.GREEN);
                } else {
                    this.g.setColor(Color.RED);
                }
                RobotRecord rr = this.locTracker.getLatest(botName);
                RobotState rs = rr.state();
                if (rs.location() == null) continue;
                this.g.drawRect((int)rs.location().getX().minus(RulesFacade.BOT_WIDTH.divide(2.0)).toDouble(), (int)rs.location().getY().minus(RulesFacade.BOT_HEIGHT.divide(2.0)).toDouble(), (int)RulesFacade.BOT_WIDTH.toDouble(), (int)RulesFacade.BOT_HEIGHT.toDouble());
            }
            this.g.setColor(c);
        }
        this.g = null;
    }
}

