/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Distance;
import bh.units.Duration;
import bh.units.Heading;
import bh.units.Location;
import bh.units.Velocity;
import bh.units.interfaces.AbsoluteToRelative;
import bh.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeLocation
implements AbsoluteToRelative<RelativeLocation, RelativeLocation> {
    private final Vector vector;

    public RelativeLocation(Vector vector) {
        this.vector = vector;
    }

    public RelativeLocation(Location source, Location target) {
        this(new Vector(source.toVector(), target.toVector()));
    }

    public RelativeLocation(Distance x, Distance y) {
        this(new Vector(x, y));
    }

    public RelativeLocation(Heading heading, Distance distance) {
        this(distance.times(heading.toAngle().sin()), distance.times(heading.toAngle().cos()));
    }

    public Distance getX() {
        return this.vector.getX();
    }

    public Distance getY() {
        return this.vector.getY();
    }

    public Vector toVector() {
        return this.vector;
    }

    public Distance getDistance() {
        return this.vector.getMagnitude();
    }

    public Heading getHeading() {
        return this.vector.toHeading();
    }

    @Override
    public RelativeLocation minus(RelativeLocation rl) {
        return new RelativeLocation(this.vector.minus(rl.vector));
    }

    @Override
    public RelativeLocation plus(RelativeLocation rl) {
        return new RelativeLocation(this.vector.plus(rl.vector));
    }

    public Velocity divide(Duration duration) {
        return new Velocity(this.getHeading(), this.getDistance().divide(duration));
    }

    public String toString() {
        return this.vector.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RelativeLocation)) {
            return false;
        }
        RelativeLocation rl = (RelativeLocation)o;
        return rl.vector.equals(this.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }
}

