/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Heading;
import shrub.Line;
import shrub.Location;

public class Box {
    private final Location mCornerTL;
    private final Location mCornerTR;
    private final Location mCornerBL;
    private final Location mCornerBR;

    public static Box valueOf(Location corner1, Location corner2) {
        Box answer = new Box(corner1, corner2);
        return answer;
    }

    private Box(Location corner1, Location corner2) {
        double x1 = corner1.GetX();
        double y1 = corner1.GetY();
        double x2 = corner2.GetX();
        double y2 = corner2.GetY();
        double xLeft = 0.0;
        double xRight = 0.0;
        double yTop = 0.0;
        double yBottom = 0.0;
        if (x1 < x2) {
            xLeft = x1;
            xRight = x2;
        } else {
            xLeft = x2;
            xRight = x1;
        }
        if (y1 < y2) {
            yTop = y2;
            yBottom = y1;
        } else {
            yTop = y1;
            yBottom = y2;
        }
        this.mCornerTL = Location.valueOf(xLeft, yTop);
        this.mCornerTR = Location.valueOf(xRight, yTop);
        this.mCornerBL = Location.valueOf(xLeft, yBottom);
        this.mCornerBR = Location.valueOf(xRight, yBottom);
    }

    public final Location GetCornerTL() {
        return this.mCornerTL;
    }

    public final Location GetCornerTR() {
        return this.mCornerTR;
    }

    public final Location GetCornerBL() {
        return this.mCornerBL;
    }

    public final Location GetCornerBR() {
        return this.mCornerBR;
    }

    public final double GetMinX() {
        return this.mCornerTL.GetX();
    }

    public final double GetMaxX() {
        return this.mCornerBR.GetX();
    }

    public final double GetMinY() {
        return this.mCornerBL.GetY();
    }

    public final double GetMaxY() {
        return this.mCornerTR.GetY();
    }

    public final boolean IsInside(Location theLocn) {
        boolean answer = false;
        if (theLocn.GetX() >= this.GetMinX() && theLocn.GetY() >= this.GetMinY() && theLocn.GetX() <= this.GetMaxX() && theLocn.GetY() <= this.GetMaxY()) {
            answer = true;
        }
        return answer;
    }

    public final Location EdgeIntersectOutward(Line theLine) {
        Location answer = null;
        Location lineStart = theLine.GetStartLocn();
        Heading lineHdng = theLine.GetHeading();
        if (!this.IsInside(lineStart)) {
            System.out.println("Box::EdgeIntersectOutward(), locn not inside");
        } else {
            Line edge1 = null;
            Line edge2 = null;
            if (lineHdng.Get() < 0.1) {
                edge2 = edge1 = Line.valueOfStartEnd(this.mCornerTL, this.mCornerTR);
            } else if (lineHdng.Get() < 89.9) {
                edge1 = Line.valueOfStartEnd(this.mCornerTL, this.mCornerTR);
                edge2 = Line.valueOfStartEnd(this.mCornerBR, this.mCornerTR);
            } else if (lineHdng.Get() < 90.1) {
                edge2 = edge1 = Line.valueOfStartEnd(this.mCornerBR, this.mCornerTR);
            } else if (lineHdng.Get() < 179.9) {
                edge1 = Line.valueOfStartEnd(this.mCornerBR, this.mCornerTR);
                edge2 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerBR);
            } else if (lineHdng.Get() < 180.1) {
                edge2 = edge1 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerBR);
            } else if (lineHdng.Get() < 269.9) {
                edge1 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerTL);
                edge2 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerBR);
            } else if (lineHdng.Get() < 270.1) {
                edge2 = edge1 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerTL);
            } else if (lineHdng.Get() < 359.9) {
                edge1 = Line.valueOfStartEnd(this.mCornerBL, this.mCornerTL);
                edge2 = Line.valueOfStartEnd(this.mCornerTL, this.mCornerTR);
            } else {
                edge2 = edge1 = Line.valueOfStartEnd(this.mCornerTL, this.mCornerTR);
            }
            Location intPoint1 = edge1.IntersectionLocn(theLine);
            if (edge1 == edge2) {
                answer = intPoint1;
            } else {
                double intDist2;
                Location intPoint2 = edge2.IntersectionLocn(theLine);
                double intDist1 = intPoint1.DistanceTo(lineStart);
                answer = intDist1 < (intDist2 = intPoint2.DistanceTo(lineStart)) ? intPoint1 : intPoint2;
            }
        }
        return answer;
    }

    public void Print() {
        System.out.println("========== Box ==========");
        System.out.println(" BL: " + this.mCornerBL);
        System.out.println(" TL: " + this.mCornerTL);
        System.out.println(" TR: " + this.mCornerTR);
        System.out.println(" BR: " + this.mCornerBR);
        System.out.println();
    }
}

