package kvk.GLGraphics;
import java.awt.Color;
import java.lang.reflect.*;
import robocode.robocodeGL.LabelGL;
import robocode.robocodeGL.LineGL;
import robocode.robocodeGL.system.GLRenderer;

/**
 *  Affiche les stats d'un Guess Factor Gun avec RobocodeGL
 *
 * @author     Ssin.le.Terrible
 * @created    13 mars 2004
 */
public class StatGrapherGL extends StatGrapher {
	private  LineGL[]  graph;
	private  LineGL[]  outlines;
	private  LabelGL   label;

	public StatGrapherGL(String name, Color color) {
		super(name, color);
		label = new LabelGL(name);
		this.color = color;
		outlines = new LineGL[4];
	}


	public void setFrame(double x, double y, double width, double height) {
		setX(x);
		setY(y);
		setWidth(width);
		setHeight(height);
	}

	public void setX(double x) {
		this.x = x;
	}

	public void setY(double y) {
		this.y = y;
	}

	public void setWidth(double width) {
		this.width = width;
	}

	public void setHeight(double height) {
		this.height = height;
	}

	public void setStats(Object stats) {
		this.stats = this.selected = stats;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public void selectSegment(int[] indices) {
		Object  temp  = stats;

		for (int i = 0; indices != null && i < indices.length; i++) {
			temp = Array.get(temp, indices[i]);
		}

		selected = temp;
	}

	public void draw() {
		double  highestValue  = 1;

		remove();

		//Contour
		for (int i = 0; i < 4; i++) {
			outlines[i] = new LineGL();
			outlines[i].setColor(Color.MAGENTA);
			GLRenderer.getInstance().addRenderElement(outlines[i]);
		}
		outlines[0].setLine(x - 1, y - 1, x + width + 1, y - 1);
		outlines[1].setLine(x + width + 1, y - 1, x + width + 1, y + height + 1);
		outlines[2].setLine(x + width + 1, y + height + 1, x - 1, y + height + 1);
		outlines[3].setLine(x - 1, y + height + 1, x - 1, y - 1);
		outlines[2].addLabel(label);

		//Stats
		graph = new LineGL[Array.getLength(selected) - 1];

		for (int i = 0; i < Array.getLength(selected); i++) {
			if (Array.getDouble(selected, i) > highestValue) {
				highestValue = Array.getDouble(selected, i);
			}
		}
		//highestValue = 100d;

		for (int i = 0; i < graph.length; i++) {
			graph[i] = new LineGL();
			graph[i].setColor(color);
			graph[i].setWidth(lineWidth);
			graph[i].setLine(x + width * i / graph.length, y + height * Array.getDouble(selected, i) / highestValue,
					x + width * (i + 1) / graph.length, y + height * Array.getDouble(selected, i + 1) / highestValue);
			GLRenderer.getInstance().addRenderElement(graph[i]);
		}
	}

	public void remove() {
		if (outlines != null) {
			for (int i = 0; i < 4; i++) {
				if (outlines[i] != null) {
					outlines[i].remove();
				}
			}
		}
		if (graph != null) {
			for (int i = 0; i < graph.length; i++) {
				if (graph[i] != null) {
					graph[i].remove();
				}
			}
		}
	}
}

