package axeBots;
import robocode.*;
import java.awt.geom.*;

public class BulletTracker extends Condition {

    private long expectedTimeOfImpact;
    private String targetName;
    private Bullet bullet;
    private AdvancedRobot myRobot;
    private int aimMethod;
    private boolean hitTarget;
    //private boolean             shouldHit = false;
    private double targetDist;
    private Point2D.Double impactPt = null;
    //private Point2D.Double		myFirePos = null;
    private double impactTime = Double.NaN;
    private double facingAngle = 0;

    //private AxeVector missVec = null;
    private AxeVector meToTarg = null;

    public BulletTracker(
        AdvancedRobot ar,
        Bullet b,
        String targetName,
        long timeToImpact,
        int aimMethod,
        double targetDist,
        double angle,
        Point2D.Double pt,
        AxeVector meToTarg) {

        if (b != null) {

            this.myRobot = ar;
            this.bullet = b;
            this.targetName = targetName;
            this.expectedTimeOfImpact = ar.getTime() + timeToImpact;
            this.aimMethod = aimMethod;
            this.hitTarget = false;
            this.targetDist = targetDist;
            this.impactPt = pt;
            this.meToTarg = meToTarg;
            this.setFacingAngle(angle);
            myRobot.addCustomEvent(this);
        }

    }

    public long getExpectedTimeOfImpact() {
        return expectedTimeOfImpact;
    }
    public double getTargetDist() {
        return targetDist;
    }
    public String getTargetName() {
        return targetName;
    }
    public Bullet getBullet() {
        return bullet;
    }
    public int getAimMethod() {
        return aimMethod;
    }
    public boolean hitTarget() {
        return hitTarget;
    }
    public Point2D.Double getPoint() {
        return impactPt;
    }

    public boolean test() {

        if (targetName.equals(bullet.getVictim())) {
            hitTarget = true;
            this.setImpactTime(HataMoto.getIt().getTime());
            myRobot.removeCustomEvent(this);
            //myRobot.//out.println(">>>>> acertou:"+bullet.getVictim());
            return true;
        }

        if (bullet.getVictim() != null) {
            myRobot.removeCustomEvent(this);
            //myRobot.//out.println(">>>>> acertou outro:"+bullet.getVictim()+" targetName"+targetName );
        }

        if (expectedTimeOfImpact <= myRobot.getTime()) {

            //impactPt = new Point2D.Double(bullet.getX(),bullet.getY());
            //AxeVector meToTarg = new AxeVector(myFirePos,impactPt);
        }

        if (!bullet.isActive()) {
            hitTarget = false;
            myRobot.removeCustomEvent(this);
            //myRobot.//out.println(">>>>> errou:"+targetName);
            return true;
        }

        return false;
    }
    /**
     * @return
     */
    public double getImpactTime() {
        return impactTime;
    }

    /**
     * @param d
     */
    public void setImpactTime(double d) {
        impactTime = d;
    }

    /**
     * @return
     */
    public AxeVector getMeToTarg() {
        return meToTarg;
    }

    /**
     * @return
     */
    public double getFacingAngle() {
        return facingAngle;
    }

    /**
     * @param d
     */
    public void setFacingAngle(double d) {
        facingAngle = d;
    }

}
