package hamilton;

public class PeriodicAiming
{
	static public FiringSolution getSolution(AimingInfo someInfo)
	{
		Coordinate targetCoordinates = someInfo.aimingTarget.getCoordinates();
		
		double firepower = calculateFirepower(someInfo);
		double bulletVelocity = 20 - (3 * firepower);

		double halfPeriod = someInfo.aimingTarget.stats.averageHalfPeriod.getMean();		
		double amplitude = Calculator.getMaxPeriodicDisplacement(halfPeriod);
	
		// calculate how many cycles before our shot arrives
		double timeOfFlight = someInfo.targetDistance / bulletVelocity;
		double offset = (timeOfFlight / halfPeriod) * (Math.PI/2);

		// adjust phase based off of time since last reversal
		double timeSinceLastReverse = someInfo.aimingTarget.getTimeStamp() - someInfo.aimingTarget.lastReverseTime;
		double phaseAdjust = (timeSinceLastReverse / halfPeriod) * (Math.PI/2);
		if (phaseAdjust > Math.PI) phaseAdjust = (Math.PI/2);
		double distanceBackToOrigin = Math.sin(phaseAdjust) * amplitude;
		Coordinate origin = targetCoordinates.getCoordinates(Calculator.normalizeAngle(someInfo.targetHeading - Math.PI), distanceBackToOrigin);
		
		// figure aimingPoint
		double relativeAimingPoint = ((Math.sin(offset + phaseAdjust) + 1) / 2) * amplitude;
		Coordinate intersection = origin.getCoordinates(someInfo.targetHeading, relativeAimingPoint);
		
		// System.out.println(timeSinceLastReverse + " PA = " + phaseAdjust + " O = " + offset + " RAP = " + relativeAimingPoint + " H = " + someInfo.targetHeading + " V = " + someInfo.targetVelocity);
		
		// System.out.println(halfPeriod + ", " + timeSinceLastReverse + ", " + relativePosition + ", " + amplitude);
		
		// System.out.println(Math.sin(phaseAdjust) + " * " + amplitude + " = " + distanceBackToOrigin);
		
		// System.out.println("Current = " + targetCoordinates.getX() + "," + targetCoordinates.getY() + " Origin = " + origin.getX() + "," + origin.getY() + " Intersection = " + intersection.getX() + "," + intersection.getY());
		
		double firingAngle = someInfo.robotCoordinates.absoluteBearingTo(intersection);
		
		return new FiringSolution(firingAngle, firepower, true);
	}
	
	static public double calculateFirepower(AimingInfo someInfo)
	{
		double energyFirepower = (someInfo.aimingTarget.getEnergy() / 4) + .1;
		double distanceFirepower = (300 / someInfo.targetDistance);
	
		if (energyFirepower > distanceFirepower) return Math.min(distanceFirepower, 3);
		else return Math.min(energyFirepower, 3);
	}
}
