package kawigi.sbf.core;
import robocode.*;
import kawigi.sbf.utils.*;

/**
 * RadarManager - Static methods to run FloodHT's radar.
 */
public class RadarManager
{
	private static double radarDirection = 1;
	
	public static void doRadar(TeamRobot robot, VolatileEnemy target)
	{
		if (target != null && (robot.getOthers() == 1 || robot.getGunHeat()/robot.getGunCoolingRate() <= 5) && (robot.getTime()-target.lastScanTime < 12 || robot.getGunHeat() > 0))
			lockRadar(robot, target);
		else
			spinRadar(robot);
	}
	
	/**
	 *	Spinning the radar:
	 **/
	public static void spinRadar(TeamRobot robot)
	{
		robot.setTurnRadarRightRadians(getRadarDirection()*100 /* arbitrary number */);
	}
	
	/**
	 *	Magic radar lock:
	 **/
	public static void lockRadar(TeamRobot robot, VolatileEnemy e)
	
	{
		double radarTurn = Utils.normalize(Utils.angle(e, Utils.getMyLocation())-robot.getRadarHeadingRadians());
		if (radarTurn > 0)
		{
			radarTurn += Math.PI/8;
			setRadarDirection(1);
		}
		else
		{
			radarTurn -= Math.PI/8;
			setRadarDirection(-1);
		}
		robot.setTurnRadarRightRadians(radarTurn);
	}
	
	public static double getRadarDirection()
	{
		return radarDirection;
	}
	
	public static void setRadarDirection(double direction)
	{
		radarDirection = direction;
	}
}
