package staticline.whiskey.targeting;

import java.util.Vector;

import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import staticline.IRobotManager;
import staticline.whiskey.AbstractWhiskeyManager;
import staticline.whiskey.Whiskey;

/**
 * Targeting module. Uses all intel to hit the enemy. Currently with only a simple
 * pattern matcher gun.
 * 
 * @author "Carsten Witzke"
 */
public class TargetingManager extends AbstractWhiskeyManager implements IRobotManager {
	
	public TargetingManager(AdvancedRobot b) {
		super(b); 
	}

	public void initialize() {

	}

	public void onScannedRobot(ScannedRobotEvent e) {
		//add new values to movement Vectors
        this.bot.dv.push(this.bot.t_delta_v);
        this.bot.dh.push(this.bot.t_delta_h);
        
        //do (a simple) pattern match
        if (this.bot.dv.size() > Whiskey.windowSize){
            //univariant - search for patterns in every timeseries
        	doPatternMatch(this.bot.dh, 2);
        	doPatternMatch(this.bot.dv, 1);
        }
        
        this.bot.bulletPower = Math.min(600 / e.getDistance(), 3);
        this.bot.bulletFlightTime = e.getDistance()/this.bot.bulletSpeed;
        int ticks = (int) Math.round(this.bot.bulletFlightTime);
        //project the targets movement
        this.bot.projectedX = this.bot.scannedX;
        this.bot.projectedY = this.bot.scannedY;
        double absHeading = e.getHeadingRadians();
        double targetSpeed = e.getVelocity();
        
        double theta;
        if(this.bot.t_energy_old == 0 || this.bot.t_distance <= 50){
        	//target is disabled or very close - aim head on
        	this.bot.bulletPower = 3;
        	theta = this.bot.getHeadingRadians() + e.getBearingRadians();
        	this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle(theta - this.bot.getGunHeadingRadians()));
        }else{
        	//default targeting via pm gun
	        if(this.bot.best_dh_index != -1 && this.bot.best_dv_index != -1){
	            double nextDeltaV = 0.;
	            double nextDeltaH = 0.;
	            this.bot.intermediateX = new int[ticks];
	            this.bot.intermediateY = new int[ticks];
	            for(int tick=0; tick<ticks; ++tick){
	                //look in timeseries
	                try{
	                    nextDeltaV = this.bot.dv.get(this.bot.best_dv_index+tick);
	                    nextDeltaH = this.bot.dh.get(this.bot.best_dh_index+tick);
	                }catch(ArrayIndexOutOfBoundsException oob){
	                	//TODO: selfnote: I can't see into the future! Fix IndexOutOfBounds Exceptions!
	                	//oob.printStackTrace();
	                	nextDeltaV = 0;
	                	nextDeltaH = 0;
	                }
	                //calc new position
	                double addX = Math.round(Math.sin(absHeading+nextDeltaH) * (targetSpeed+nextDeltaV));
	                double addY = Math.round(Math.cos(absHeading+nextDeltaH) * (targetSpeed+nextDeltaV));
	                
	                //don't add coordinates out of the battlefield
	                if(this.bot.projectedX + addX > this.bot.fieldRect.getWidth()){
	                	this.bot.projectedX = (int) this.bot.fieldRect.getMaxX();
	                }else if(this.bot.projectedX + addX > this.bot.fieldRect.getWidth()){
	                	this.bot.projectedX = (int) this.bot.fieldRect.getMinX();
	                }else{
	                	this.bot.projectedX += addX;
	                }
	                
	                if(this.bot.projectedY + addY > this.bot.fieldRect.getHeight()){
	                	this.bot.projectedY = (int) this.bot.fieldRect.getMaxY();
	                }else if(this.bot.projectedY + addX > this.bot.fieldRect.getHeight()){
	                	this.bot.projectedY = (int) this.bot.fieldRect.getMinY();
	                }else{
	                	this.bot.projectedY += addY;
	                }
	                
	                this.bot.intermediateX[tick] = this.bot.projectedX;
	                this.bot.intermediateY[tick] = this.bot.projectedY;
	                //update absolute values
	                absHeading = absHeading + nextDeltaH;
	                if(targetSpeed + nextDeltaV >= -Rules.MAX_VELOCITY && targetSpeed + nextDeltaV <= Rules.MAX_VELOCITY){
	                    targetSpeed = targetSpeed + nextDeltaV;
	                }
	            }
	            
	            //aim for that projected spot 
	            this.bot.t_delta_x = this.bot.projectedX - this.bot.getX();
	            this.bot.t_delta_y = this.bot.projectedY - this.bot.getY();
	            theta = Math.atan2(this.bot.t_delta_x, this.bot.t_delta_y);
	            this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle(theta - this.bot.getGunHeadingRadians()));
	        }
        }
	}
	
	/**
     * start window-sliding if stored data indices > windowSize
     * pattern: reference; last windowSize indices in timeline
     * window: slides through time series
     *  
     * @param timeseries a Vector<double> of data
     * @param type 1=delta-velocity, 2=delta=heading
     */
    private void doPatternMatch(Vector<Double> timeseries, int type){
        //init the reference pattern vector
        Vector<Double> pattern = new Vector<Double>();
        int startindex = timeseries.size()-Whiskey.windowSize-1;
        for(int j=startindex; j<(startindex+Whiskey.windowSize); j++){
            pattern.add(timeseries.get(j));
        }
        
        double best_dist = Double.MAX_VALUE;
        for(int iteration=0; iteration<(timeseries.size()-Whiskey.windowSize); iteration++){
            //init the window vector
            Vector<Double> window = new Vector<Double>();
            //fill window
            for(int i=iteration; i<(iteration+Whiskey.windowSize); i++){
                window.add(timeseries.get(i));
            }
            //calc distance and get minimum
            double dist = this.getDistance(window, pattern);
            if(dist<=best_dist){
                best_dist = dist;
                switch(type){
                    case 0://do nothing
                        System.out.println(iteration);
                        break;
                    case 1://delta velocity
                    	this.bot.best_dv_index = iteration;
                        break;
                    case 2://delta heading
                    	this.bot.best_dh_index = iteration;
                        break;
                    default:
                        System.out.println("Invalid type given ("+type+")!");
                }
            }
        }//end of iteration
    }
    
    private double getDistance(Vector<Double> pattern1, Vector<Double> pattern2){
        double dist = .0;
        for(int i=0; i<pattern1.size(); i++){
            dist += pattern1.get(i) - pattern2.get(i);
        }
        return dist;
    }

}
