package staticline.whiskey.utils;

import java.io.Serializable;


public class Pattern implements Comparable<Pattern>, Serializable{
	//private static final long serialVersionUID = 609291041904421672L;
	public String patternString;
	public double[] patternDouble = new double[]{ Double.MAX_VALUE };//default
	public int globalOccurences;
	public int localOccurences;
	public String type;
	public String column;

	/**
	 * A movement or heading pattern.
	 * @param patt the symbolic pattern string
	 * @param gOcc global occurrence of the pattern of all types of bots (wavesurfer, etc.)
	 * @param lOcc local occurrence of the pattern within the current bot type
	 * @param ty the current bot type
	 * @param col the data column where the pattern was found (see data logs)
	 */
	public Pattern(String patt, int gOcc, int lOcc, String ty, String col){
		this.patternString = patt;
		this.globalOccurences = gOcc;
		this.localOccurences = lOcc;
		this.type = ty;
		this.column = col;
	}
	
	/**
	 * A movement or heading pattern.
	 * @param patt the pattern string as double[]
	 * @param gOcc global occurrence of the pattern of all types of bots (wavesurfer, etc.)
	 * @param lOcc local occurrence of the pattern within the current bot type
	 * @param ty the current bot type
	 * @param col the data column where the pattern was found (see data logs)
	 */
	public Pattern(double[] patt, int gOcc, int lOcc, String ty, String col){
		//DecimalFormat df = new DecimalFormat("#0.00");
		this.patternDouble = patt;
		this.patternString = "p_"+System.currentTimeMillis();
		
		this.globalOccurences = gOcc;
		this.localOccurences = lOcc;
		this.type = ty;
		this.column = col;
	}
	
	/**
	 * A movement or heading pattern without count of occurrences.
	 * @param patt the symbolic pattern string
	 * @param ty the current bot type
	 * @param col the data column where the pattern was found (see data logs)
	 */
	public Pattern(String patt, String ty, String col){
		this.patternString = patt;
		this.type = ty;
		this.column = col;
		
		this.globalOccurences = 0;
		this.localOccurences = 0;
	}
	
	public int compareTo(Pattern pat) {
		int comp = this.globalOccurences - pat.globalOccurences;
		if(comp==0) {
			comp = this.patternString.compareTo(pat.patternString);
		}
		return comp;
	}
	
	public boolean equals(Pattern pat) {
		boolean match = true;
		if(this.patternDouble[0]==Double.MAX_VALUE){
			match = this.patternString.equals(pat.patternString);
		}else{
			for(int i=0;i<pat.patternDouble.length;i++){
				if(this.patternDouble[i]!=pat.patternDouble[i]){
					match = false;
					break;
				}
			}
		}
		return (this.patternString.equals(pat.patternString) && match);
	}

	@Override
	public String toString() {
		//something like "ABBDDDE,44,16,wavesurfer,dHead" or "{0.3,1.3,0.01},44,16,wavesurfer,dHead"
		return this.patternString + "," +  
			this.globalOccurences + "," + this.localOccurences + "," + 
			this.type + "," + this.column;
	}
}
