package ph.intelligence;
import ph.*;
import robocode.*;
import java.util.*;

public class RadarModule extends RobotModule {
    
    public RadarModule(ModularRobot robot) {
        this.robot=robot;
        robot.setAdjustRadarForGunTurn(true);
        robot.setAdjustRadarForRobotTurn(true);
        robot.setTurnRadarRight(1480);
    }
    
    static final double PI=Math.PI;
    
    public void execute() {
        if(Math.abs(robot.getRadarTurnRemaining())>0.01) return;
        if(robot.getOthers()==1) {
            double radarOffset;
            robotInfo target=(robotInfo)robot.otherRobotsInfo.firstElement();
            if(robot.getTime()-target.time()<16) {
                radarOffset = robot.getRadarHeadingRadians()
                - absbearing(robot.getX(),robot.getY(),target.x(),target.y());
                if (radarOffset < 0)
                    radarOffset -= PI/8;
                else
                    radarOffset += PI/8;
                robot.setTurnRadarLeftRadians(NormaliseBearing(radarOffset));
            } else {
                robot.setTurnRadarRight(72);
            }
        } else {
            for(int i=0; i<robot.otherRobotsInfo.size(); i++) {
                robotInfo target=(robotInfo)robot.otherRobotsInfo.elementAt(i);
                if(target.focusOn&&robot.getTime()-target.time()<16) {
                    double radarOffset;
                    radarOffset = robot.getRadarHeadingRadians()
                    - absbearing(robot.getX(),robot.getY(),target.x(),target.y());
                    if (radarOffset < 0)
                        radarOffset -= PI/2;
                    else
                        radarOffset += PI/2;
                    robot.setTurnRadarLeftRadians(NormaliseBearing(radarOffset));
                    return;
                }
            }
            robot.setTurnRadarRight(36);
        }
    }
    
    double NormaliseBearing(double ang) {
        if (ang > PI)
            ang -= 2*PI;
        if (ang < -PI)
            ang += 2*PI;
        return ang;
    }
    
    public double absbearing( double x1,double y1, double x2,double y2 ) {
        double xo = x2-x1;
        double yo = y2-y1;
        double h = utils.dist( x1,y1, x2,y2 );
        if( xo > 0 && yo > 0 ) {
            return Math.asin( xo / h );
        }
        if( xo > 0 && yo < 0 ) {
            return Math.PI - Math.asin( xo / h );
        }
        if( xo < 0 && yo < 0 ) {
            return Math.PI + Math.asin( -xo / h );
        }
        if( xo < 0 && yo > 0 ) {
            return 2.0*Math.PI - Math.asin( -xo / h );
        }
        return 0;
    }
    
}
