package donjezza;
import robocode.*;
import java.awt.Color;

/**
 * Jezza
 */
public class Jezza extends Robot
{
	/**
	 * run: Jezza's default behavior
	 */ 
	
	public void run() 
	{
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setBodyColor(Color.blue);
		setGunColor(Color.red);
		setBulletColor(Color.white);
		setScanColor(Color.red);
		while(true) 
		{
			look();
			move();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		double turn = getHeading() + e.getBearing() - getGunHeading();
		if(turn <= -180)
		{
			turn = turn + 360;
		}
		if(turn > 180)
		{
			turn = turn -360;
		}
		turnGunRight(turn);
		if(e.getDistance() <200)
		{
			fire(3);
		}
		else
		{
			fire(1);
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) 
	{
		double bear = e.getBearing();
		turnRight(-bear/bear*(90-bear));
		ahead(100);
	}

	private void look()
	{
		turnRadarRight(360);
	}

	private void move()
	{
		double dist = Math.random()*250 + 50;
		double turn = Math.random()*90;
		if(Math.random()<0.5)
		{
			ahead(dist);
		}
		else
		{
			back(dist);
		}
		if(Math.random()<0.3) return;
		if(Math.random()<0.5)
		{
			turnRight(turn);
		}
		else
		{
			turnLeft(turn);
		}
	}
}