package shinh;

import robocode.*;

import java.util.*;
import java.awt.Color;
import java.io.*;

public class Entangled extends AdvancedRobot {
	public Radar radar;
	public EnemyMgr emgr;
	public Fire fire;
	public BulletMgr bmgr;

	static public MoveRevolver move = null;
	static public HashMap name2pred = null;

	public Enemy target = null;

	public long lastBulletTurn;

	public double lastHitX = -10000;
	public double lastHitY = -10000;
	public long lastHitTurn = 0;

	public double fieldW;
	public double fieldH;
	public double fieldW_2;
	public double fieldH_2;
	public double fieldD;
	public double fieldD2;

	public String lastBulletedName;
	private int lastBulletedTime_ = 0;

	public static Entangled me;

	public PatternMatcher pattern;

	public Being self;

	public void run() {
		me = this;

		self = new Being();
		pattern = new PatternMatcher(self);

		fieldW = getBattleFieldWidth();
		fieldH = getBattleFieldHeight();
		fieldW_2 = fieldW / 2;
		fieldH_2 = fieldH / 2;
		fieldD = Util.length(fieldW, fieldH);
		fieldD2 = Util.length2(fieldW, fieldH);

		if (name2pred == null) name2pred = new HashMap();

		emgr = new EnemyMgr();
		bmgr = new BulletMgr();

		if (getOthers() > 1) radar = new RadarMelee2();
		else radar = new RadarOne();

		if (move == null) move = new MoveRevolver();
		else move.init(); 

		if (getOthers() > 1) fire = new FireMelee();
		else fire = new FireOne();

		setAdjustGunForRobotTurn(true);

		setColors(new Color(0, 0, 0),
				  new Color(255, 255, 255),
				  new Color(220, 220, 255));

		while (true) {
			try {
				//startTimer("update self");
				updateSelf();
				//endTimer("update self");
				//startTimer("targetting");
				targetting();
				//endTimer("targetting");
				//startTimer("enemy mgr");
				emgr.update();
				//endTimer("enemy mgr");
				//startTimer("bullet mgr");
				bmgr.update();
				//endTimer("bullet mgr");
				//startTimer("radar");
				radar.update();
				//endTimer("radar");
				//startTimer("move");
				move.update();
				//endTimer("move");
				//startTimer("fire");
				fire.update();
				//endTimer("fire");
			}
			catch (Exception e) {
				try {
					PrintStream w =
						new PrintStream(
							new RobocodeFileOutputStream(
								getDataFile("exceptions")));
					e.printStackTrace(w);
					w.close();
				}
				catch (Exception ie) {
				}
			}

			execute();
		}
	}

	private long timerTime;
	private String timerName;
	static private HashMap name2time = new HashMap();

	private void startTimer(String s) {
		timerTime = (new GregorianCalendar()).getTimeInMillis();
		timerName = s;
	}
	private void endTimer(String s) {
		long t = (new GregorianCalendar()).getTimeInMillis() - timerTime;
		if (name2time.containsKey(s)) {
			name2time.put(s, new Long(t+((Long)name2time.get(s)).longValue()));
		}
		else {
			name2time.put(s, new Long(t));
		}
	}

	private void updateSelf() {
		self.x = getX();
		self.y = getY();
		self.velocity = getVelocity();
		self.heading = getHeadingRadians();
		self.turn = getTime();
		pattern.addState();
	}

	public void registBullet(Bullet b) {
		addCustomEvent(new BulletTracker(target, b, move.move));
		target.predictor.fireNum++;
		target.revolver.revolve();
		lastBulletTurn = getTime();
	}

	private void targetting() {
		if (getOthers() <= 1) {
			if (emgr.size() > 0) target = emgr.get(0);
			return;
		}

		double minlen = 100000;
		for (int i = 0; i < emgr.size(); i++) {
			Enemy enemy = emgr.get(i);
			double len = enemy.distance;

			if (enemy == target)
				len -=
					Const.TARGETTING_NOW_TARGET_POINT * fieldD *
					(1.6 - getGunHeat());

			if (enemy.energy <= 16)	len -= Const.TARGETTING_LAST_ATACK;

			if (enemy.energy == 0) len -= 1000;

			len *= (2 - enemy.predictor.getPercent() / 100);

			if (minlen > len) {
				minlen = len;
				target = enemy;
			}
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		emgr.handleScanned(e);
	}

	public void onHitByBullet(HitByBulletEvent e) {
		if (e.getName() == lastBulletedName) {
			lastBulletedTime_++;
		}
		else {
			lastBulletedName = e.getName();
			lastBulletedTime_ = 0;
		}
		if (lastBulletedTime_ > 1) {
			target = emgr.getFromName(lastBulletedName);
			lastBulletedTime_ = 0;
		}

		lastHitX = getX();
		lastHitY = getY();
		lastHitTurn = getTime();
	}

	public void onHitRobot(HitRobotEvent e) {
		out.println("ramed: " + move.move.name());

		lastBulletedName = e.getName();
		move.noticeHitRobot();
		emgr.handleHit(e);
 	}

	public void onRobotDeath(RobotDeathEvent e) {
		emgr.removeFromName(e.getName());
		if (target != null && target.name == e.getName()) target = null;
		if (getOthers() == 1) {
			target = emgr.get(0);
			radar = new RadarOne();
			fire = new FireOne();
		}
	}

	private void report() {
		Set keys = name2pred.keySet();
		Iterator ite = keys.iterator();
		while (ite.hasNext()) {
			String name = (String)ite.next();
			out.println(name + ":");
			out.print(
				((PredictRevolver2)name2pred.get(name)).getStateString());
			out.println("");
		}

		out.println(move.getStateString());

		keys = name2time.keySet();
		ite = keys.iterator();
		while (ite.hasNext()) {
			String name = (String)ite.next();
			out.print(name + ": ");
			out.println(((Long)name2time.get(name)));
		}
	}

	public void onWin(WinEvent e) {
		move.revolve();

		report();
	}

	public void onDeath(DeathEvent e) {
		move.revolve();

		report();
	}

	public void onSkippedTurn(SkippedTurnEvent e) {
		out.println("skipped");
	}

	public void onBulletHit(BulletHitEvent e) {
		if (e.getEnergy() != 0) emgr.handleBulletHit(e);
	}

	public void onBulletMissed(BulletMissedEvent e) {
	}

	public void onCustomEvent(Condition e) {
	}

	public void onHitWall(HitWallEvent e) {
		out.println("walled: " + move.move.name() + "," + getX() + "," + getY());

		move.noticeHitWall();
	}

	public void setAhead(double d) {
		double sin = Math.sin(getHeadingRadians());
		double cos = Math.cos(getHeadingRadians());
		double x = getX() + d * sin;
		double y = getY() + d * cos;

		if (x < Const.WALL_AVOID_INTERVAL) {
			if (d > 0) d = getX() - Const.WALL_AVOID_INTERVAL;
			else d = Const.WALL_AVOID_INTERVAL - getX();
		}
		else if (x > fieldW - Const.WALL_AVOID_INTERVAL) {
			if (d > 0) d = fieldW - getX() - Const.WALL_AVOID_INTERVAL;
			else d = Const.WALL_AVOID_INTERVAL + getX() - fieldW;
		}
		if (y < Const.WALL_AVOID_INTERVAL) {
			if (d > 0) d = getY() - Const.WALL_AVOID_INTERVAL;
			else d = Const.WALL_AVOID_INTERVAL - getY();
		}
		else if (y > fieldH - Const.WALL_AVOID_INTERVAL) {
			if (d > 0) d = fieldH - getY() - Const.WALL_AVOID_INTERVAL;
			else d = Const.WALL_AVOID_INTERVAL + getX() - fieldH;
		}

		super.setAhead(d);
	}

	public void setBack(double d) {
		setAhead(-d);
	}

	public void nativeSetAhead(double d) {
		super.setAhead(d);
	}

	public void nativeSetBack(double d) {
		super.setBack(d);
	}

	public boolean nearWall(double d) {
		return
			(self.x < d && self.y < d) ||
			(self.x < d && self.y > fieldH - d) ||
			(self.x > fieldW - d && self.y < d) ||
			(self.x > fieldW - d && self.y > fieldH - d);
	}

	public boolean nearEdge(double d) {
		return
			self.x < d || self.y < d ||
			self.x > fieldW - d || self.y > fieldH - d;
	}

}
