package dam.movement;

import robocode.*;
import java.util.*;

import dam.MasterBot;
import dam.Target;
import dam.util.*;

public class AntiGravity
{
	private double turnAngle;
	private int direction = 1;
	private double fieldWidth;
	private double fieldHeight;
	private Vector gridpoints = new Vector();
	public static double PI = Math.PI;
	private double xforce = 0;
	private double yforce = 0;
	
	public AntiGravity(double width, double height)
	{
		fieldWidth = width;
		fieldHeight = height;
	}
	
	public double calculate(double botx, double boty, double heading)
	{
		xforce = 0;
		yforce = 0;
		double force;
		double totalForce = 0;
		double ang;
		GridPoint p;
		for(int i = 0; i < gridpoints.size(); i++)
		{
			p = (GridPoint)gridpoints.elementAt(i);
			force = p.power/Math.pow(BotMath.getRange(botx, boty, p.x, p.y), 2);
			ang = BotMath.normaliseBearing(Math.PI/2 - Math.atan2(boty - p.y, botx - p.x));
			xforce += Math.sin(ang) * force;
			yforce += Math.cos(ang) * force;
		}
		// wall avoidance
		xforce += 100/Math.pow(BotMath.getRange(botx, boty, fieldWidth, boty), 2);
		xforce -= 100/Math.pow(BotMath.getRange(botx, boty, 0, boty), 2);
		yforce += 100/Math.pow(BotMath.getRange(botx, boty, botx, fieldHeight), 2);
		yforce -= 100/Math.pow(BotMath.getRange(botx, boty, botx, 0), 2);

		// set direction and angle of turn
		goTo(botx, boty, botx - xforce, boty - yforce, heading);
		return Math.abs(xforce) + Math.abs(yforce);
	}
	
	public boolean isClose()
	{
		return false;
	}
		
	
	public double getX(){ return xforce; }
	public double getY(){ return yforce; }
	
	
	
	private void goTo(double botx, double boty, double x, double y, double heading)
	{
		double ang = BotMath.normaliseBearing(BotMath.absbearing(botx, boty, x, y) - heading);
		int dir = 1;
		if(ang > PI/2){
			ang -= PI;
			dir = -1;
		}
		else if(ang < -(PI/2)){
			ang += PI;
			dir = -1;
		}
		else{
			dir = 1;
		}
		turnAngle = ang;
		direction = dir;
	}
	
	public double getAngle(){ return turnAngle; }
	public int getDirection(){ return direction; }
	
	public void add(GridPoint g)
	{
		gridpoints.add(g);
	}
		

}